/*
 * Decompiled with CFR 0.152.
 */
package d207validator.v0;

import d207validator.v0.DataObjectRoot;
import d207validator.v0.Declaratie207;
import d207validator.v0.ValidatorImpl;
import dec.DECConst;

public class Sect_II
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_SECT_II = 0;
    String _tip_venit;
    boolean _tip_venit_ok;
    String _nrben;
    long _nrben_f;
    boolean _nrben_ok;
    String _Tscutit;
    long _Tscutit_f;
    boolean _Tscutit_ok;
    String _Tbaza;
    long _Tbaza_f;
    boolean _Tbaza_ok;
    String _Timp;
    long _Timp_f;
    boolean _Timp_ok;

    public Sect_II(ValidatorImpl validator, DataObjectRoot parent) {
        super(validator, parent, 1);
    }

    public void checkTag(int codTag) {
        this.startValidation(codTag);
        this._tip_venit = this._validator.nextAttributeInList(this._params._naturaVeniturilor, "tip_venit", 256, 4, 1);
        this._tip_venit_ok = this._validator._attributeOK;
        this._nrben = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "nrben", 0, 1, 1);
        this._nrben_f = this._validator._integerValue;
        this._nrben_ok = this._validator._attributeOK;
        this._Tscutit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "Tscutit", 0, 1, 1);
        this._Tscutit_f = this._validator._integerValue;
        this._Tscutit_ok = this._validator._attributeOK;
        this._Tbaza = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "Tbaza", 0, 1, 1);
        this._Tbaza_f = this._validator._integerValue;
        this._Tbaza_ok = this._validator._attributeOK;
        this._Timp = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "Timp", 0, 1, 1);
        this._Timp_f = this._validator._integerValue;
        this._Timp_ok = this._validator._attributeOK;
        this.endValidation(codTag);
    }

    public void aggregation(int codTag) {
        Declaratie207 dec = (Declaratie207)this._parent;
        int tipVenit = 0;
        if (this._tip_venit_ok) {
            tipVenit = Integer.parseInt(this._tip_venit);
            if (this._nrben_ok) {
                if (this._nrben_f <= 0L) {
                    this._validator.addError(1, "R20", "", this._validator.fillParams("atributul nrBen (@0@) trebuie sa fie strict > 0", new Object[]{this._nrben}));
                } else if (dec._cntBenef[tipVenit] != 0L) {
                    this._validator.addError(1, "R19", "", this._validator.fillParams("atributul tip_venit (@0@) din sectiunea Sect_II trebuie sa fie unic pe declaratie", new Object[]{this._tip_venit}));
                } else {
                    dec._cntBenef[tipVenit] = this._nrben_f;
                }
                if (tipVenit < 12 || tipVenit > 21) {
                    if (this._Tscutit_f != 0L) {
                        this._validator.addError(1, "R21", "", this._validator.fillParams("Daca atributul tip_venit (@0@) nu este in limitele 12 si 21 atunci atributul Tscutit (@1@) trebuie sa fie = 0", new Object[]{this._tip_venit, this._Tscutit}));
                    }
                    dec._sumaBaza[tipVenit] = this._Tbaza_f;
                } else {
                    if (this._Tbaza_f != 0L) {
                        this._validator.addError(1, "R22", "", this._validator.fillParams("Daca atributul tip_venit (@0@) este in limitele 12 si 21 atunci atributul Tbaza (@1@) trebuie sa fie = 0", new Object[]{this._tip_venit, this._Tbaza}));
                    }
                    dec._sumaBaza[tipVenit] = this._Tscutit_f;
                }
                dec._sumaImp[tipVenit] = this._Timp_f;
                dec._sumaControl += this._nrben_f + this._Tscutit_f + this._Tbaza_f + this._Timp_f;
            }
        }
    }

    public void initialization() {
        this._tip_venit = null;
        this._tip_venit_ok = false;
        this._nrben = null;
        this._nrben_f = 0L;
        this._nrben_ok = false;
        this._Tscutit = null;
        this._Tscutit_f = 0L;
        this._Tscutit_ok = false;
        this._Tbaza = null;
        this._Tbaza_f = 0L;
        this._Tbaza_ok = false;
        this._Timp = null;
        this._Timp_f = 0L;
        this._Timp_ok = false;
    }
}

