/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v0;

import d212validator.v0.D212;
import d212validator.v0.DataObjectRoot;
import d212validator.v0.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Cap11
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP11 = 0;
    String _scutire;
    long _scutire_f;
    boolean _scutire_ok;
    String _reg;
    long _reg_f;
    boolean _reg_ok;
    String _categ_venit;
    long _categ_venit_f;
    boolean _categ_venit_ok;
    String _det_ven_net;
    long _det_ven_net_f;
    boolean _det_ven_net_ok;
    String _forma_org;
    long _forma_org_f;
    boolean _forma_org_ok;
    String _caen;
    long _caen_f;
    boolean _caen_ok;
    String _descriere_sediu_bun;
    boolean _descriere_sediu_bun_ok;
    String _nr_doc_autoriz;
    boolean _nr_doc_autoriz_ok;
    String _data_doc_autoriz;
    boolean _data_doc_autoriz_ok;
    Date _data_doc_autoriz_f;
    String _data_incep;
    boolean _data_incep_ok;
    Date _data_incep_f;
    String _data_sf;
    boolean _data_sf_ok;
    Date _data_sf_f;
    String _nr_zile_scutite;
    long _nr_zile_scutite_f;
    boolean _nr_zile_scutite_ok;
    String _cif_orgJN;
    long _cif_orgJN_f;
    boolean _cif_orgJN_ok;
    String _den_orgJN;
    boolean _den_orgJN_ok;
    String _venit_brut;
    long _venit_brut_f;
    boolean _venit_brut_ok;
    String _chelt_deduc;
    long _chelt_deduc_f;
    boolean _chelt_deduc_ok;
    String _venit_net_anual;
    long _venit_net_anual_f;
    boolean _venit_net_anual_ok;
    String _id_decl;
    long _id_decl_f;
    boolean _id_decl_ok;
    String _venit_net_Rsursa;
    long _venit_net_Rsursa_f;
    boolean _venit_net_Rsursa_ok;
    String _castig;
    long _castig_f;
    boolean _castig_ok;
    String _pierdere;
    long _pierdere_f;
    boolean _pierdere_ok;

    public Cap11(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._scutire = this._validator.nextAttributeInInterval(0L, 1L, "scutire", 0, 1, 1);
        this._scutire_f = this._validator._integerValue;
        this._scutire_ok = this._validator._attributeOK;
        this._reg = this._validator.nextAttributeInInterval(0L, 1L, "reg", 0, 1, 1);
        this._reg_f = this._validator._integerValue;
        this._reg_ok = this._validator._attributeOK;
        this._categ_venit = this._validator.nextAttributeInList(this._params._categ_venit_type, "categ_venit", 0, 1, 1);
        this._categ_venit_f = this._validator._integerValue;
        this._categ_venit_ok = this._validator._attributeOK;
        this._det_ven_net = this._validator.nextAttributeInInterval(1L, 3L, "det_ven_net", 0, 1, 0);
        this._det_ven_net_f = this._validator._integerValue;
        this._det_ven_net_ok = this._validator._attributeOK;
        if ((this._categ_venit_f == 1001L || this._categ_venit_f == 1002L || this._categ_venit_f == 1004L || this._categ_venit_f == 1006L || this._categ_venit_f == 1009L || this._categ_venit_f == 1010L || this._categ_venit_f == 1011L) && this._det_ven_net_f == 2L) {
            this._validator.addError(1, "R32a", "", this._validator.fillParams("Pt categ_venit in (1001,1002,1004,1006,1009,1010,1011) atunci det_ven_net<>2", new Object[0]));
        }
        if ((this._categ_venit_f == 1002L || this._categ_venit_f == 1003L || this._categ_venit_f == 1004L || this._categ_venit_f == 1005L || this._categ_venit_f == 1006L || this._categ_venit_f == 1009L || this._categ_venit_f == 1010L || this._categ_venit_f == 1011L) && this._det_ven_net_f == 3L) {
            this._validator.addError(1, "R32b", "", this._validator.fillParams("Pt categ_venit in (1002,1003,1004,1005,1006,1009,1010,1011) atunci det_ven_net<>3", new Object[0]));
        }
        this._forma_org = this._validator.nextAttributeInInterval(1L, 4L, "forma_org", 0, 1, 0);
        this._forma_org_f = this._validator._integerValue;
        this._forma_org_ok = this._validator._attributeOK;
        if (this._categ_venit_f == 1001L || this._categ_venit_f == 1002L || this._categ_venit_f == 1003L || this._categ_venit_f == 1009L || this._categ_venit_f == 1009L || this._categ_venit_f == 1010L || this._categ_venit_f == 1011L) {
            if (this._forma_org == null) {
                this._validator.addError(1, "R33a", "", this._validator.fillParams("Pt categ_venit in (1001,1002,1003,1009,1010,1011) atunci forma_org<>null", new Object[0]));
            }
        } else if (this._forma_org != null) {
            this._validator.addError(1, "R33b", "", this._validator.fillParams("Pt categ_venit not in (1001,1002,1003,1009,1010,1011) atunci forma_org=null", new Object[0]));
        }
        this._caen = this._validator.nextAttributeInList(this._params._caenList, "caen", 256, 4, 0);
        this._caen_f = this._validator._integerValue;
        this._caen_ok = this._validator._attributeOK;
        if ((this._categ_venit_f == 1001L || this._categ_venit_f == 1002L || this._categ_venit_f == 1009L || this._categ_venit_f == 1010L || this._categ_venit_f == 1011L) && this._caen == null) {
            this._validator.addError(1, "R34", "", this._validator.fillParams("Pt categ_venit not in (1001,1002,1009,1010,1011) atunci caen<>null", new Object[0]));
        }
        this._descriere_sediu_bun = this._validator.nextAttribute("descriere_sediu_bun", 250, 4, 0);
        this._descriere_sediu_bun_ok = this._validator._attributeOK;
        this._nr_doc_autoriz = this._validator.nextAttribute("nr_doc_autoriz", 15, 4, 0);
        this._nr_doc_autoriz_ok = this._validator._attributeOK;
        this._data_doc_autoriz = this._validator.nextAttribute("data_doc_autoriz", 0, 3, 0);
        this._data_doc_autoriz_f = this._validator._dateValue;
        this._data_doc_autoriz_ok = this._validator._attributeOK;
        this._data_incep = this._validator.nextAttribute("data_incep", 0, 3, 0);
        this._data_incep_ok = this._validator._attributeOK;
        this._data_incep_f = this._validator._dateValue;
        this._data_sf = this._validator.nextAttribute("data_sf", 0, 3, 0);
        this._data_sf_ok = this._validator._attributeOK;
        this._data_sf_f = this._validator._dateValue;
        if (this._data_incep != null && this._data_sf != null && this._data_sf_f.before(this._data_incep_f)) {
            this._validator.addError(1, "R39", "", this._validator.fillParams("Data sfarsit nu poate fi anterioara datei de sfarsit", new Object[0]));
        }
        this._nr_zile_scutite = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "nr_zile_scutite", 0, 1, 0);
        this._nr_zile_scutite_f = this._validator._integerValue;
        this._nr_zile_scutite_ok = this._validator._attributeOK;
        if (this._categ_venit_f != 1001L && this._categ_venit_f != 1002L && this._categ_venit_f != 1003L && this._categ_venit_f != 1009L && this._categ_venit_f != 1010L && this._categ_venit_f != 1011L && this._nr_zile_scutite != null) {
            this._validator.addError(1, "R41", "", this._validator.fillParams("Pt categ_venit not in (1001,1002,1003,1009,1010,1011) atunci nr_zile_scutite=null", new Object[0]));
        }
        if (this._nr_zile_scutite_f > 366L) {
            this._validator.addError(1, "R41b", "", this._validator.fillParams("nr_zile_scutite nu  poate fi mai mare decat 366", new Object[0]));
        }
        this._cif_orgJN = this._validator.nextAttributeAsCif("cif_orgJN", 0);
        this._cif_orgJN_f = this._validator._integerValue;
        this._cif_orgJN_ok = this._validator._attributeOK;
        this._den_orgJN = this._validator.nextAttribute("den_orgJN", 200, 4, 0);
        this._den_orgJN_ok = this._validator._attributeOK;
        this._venit_brut = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "venit_brut", 0, 1, 1);
        this._venit_brut_f = this._validator._integerValue;
        this._venit_brut_ok = this._validator._attributeOK;
        if (this._det_ven_net_f == 1L && (this._categ_venit_f > 1000L && this._categ_venit_f < 1007L || this._categ_venit_f == 1009L || this._categ_venit_f == 1010L || this._categ_venit_f == 1011L) && (this._forma_org_f == 2L || this._forma_org_f == 3L) && this._venit_brut_f > 0L) {
            this._validator.addError(1, "R46a", "", this._validator.fillParams("Pt categ_venit in (1001,1002,1003,1004,1005,1006,1009,1010,1011) si det_ven_net=1 si forma_org=2 sau forma_org=3 atunci venit_brut=0", new Object[0]));
        }
        if (this._det_ven_net_f == 3L && this._venit_brut_f > 0L) {
            this._validator.addError(1, "R46b", "", this._validator.fillParams("Pt  det_ven_net=3 atunci venit_brut=0", new Object[0]));
        }
        if (this._categ_venit_f == 1012L && this._venit_brut_f > 0L) {
            this._validator.addError(1, "R46c", "", this._validator.fillParams("Pt categ_venit = 1012 atunci venit_brut=0", new Object[0]));
        }
        this._chelt_deduc = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "chelt_deduc", 0, 1, 1);
        this._chelt_deduc_f = this._validator._integerValue;
        this._chelt_deduc_ok = this._validator._attributeOK;
        if (this._det_ven_net_f == 1L && (this._categ_venit_f > 1000L && this._categ_venit_f < 1007L || this._categ_venit_f == 1009L || this._categ_venit_f == 1010L || this._categ_venit_f == 1011L) && (this._forma_org_f == 2L || this._forma_org_f == 3L) && this._chelt_deduc_f > 0L) {
            this._validator.addError(1, "R47a", "", this._validator.fillParams("Pt categ_venit in (1001,1002,1003,1004,1005,1006,1009,1010,1011) si det_ven_net=1 si forma_org=2 sau forma_org=3 atunci chelt_deduc=0", new Object[0]));
        }
        if (this._det_ven_net_f == 3L && this._chelt_deduc_f > 0L) {
            this._validator.addError(1, "R47b", "", this._validator.fillParams("Pt  det_ven_net=3 atunci chelt_deduc=0", new Object[0]));
        }
        if ((this._categ_venit_f == 1012L || this._categ_venit_f == 1013L) && this._chelt_deduc_f > 0L) {
            this._validator.addError(1, "R47c", "", this._validator.fillParams("Pt categ_venit in (1012,1013) atunci chelt_deduc=0", new Object[0]));
        }
        if (this._det_ven_net_f == 2L && (this._categ_venit_f == 1003L || this._categ_venit_f == 1005L) && this._chelt_deduc_f != Math.round(0.4 * (double)this._venit_brut_f)) {
            this._validator.addError(1, "R47d", "", this._validator.fillParams("Pt det_ven_net=2 si categ_venit in (1003,1005) atunci chelt_deduc=Round(0.4*venit_brut)", new Object[0]));
        }
        this._venit_net_anual = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "venit_net_anual", 0, 1, 1);
        this._venit_net_anual_f = this._validator._integerValue;
        this._venit_net_anual_ok = this._validator._attributeOK;
        long l = -1L;
        if ((this._categ_venit_f < 1001L || this._categ_venit_f > 1006L) && (this._categ_venit_f <= 1008L || this._categ_venit_f >= 1012L) || this._det_ven_net_f != 1L || this._forma_org_f != 2L && this._forma_org_f != 3L) {
            l = this._venit_brut_f > this._chelt_deduc_f ? this._venit_brut_f - this._chelt_deduc_f : 0L;
        }
        if (this._categ_venit_f == 1012L || this._categ_venit_f == 1013L) {
            l = 0L;
        }
        if (this._venit_net_anual_f != l && l >= 0L) {
            this._validator.addError(1, "R48", "", this._validator.fillParams("venit_net_anual(@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(this._venit_net_anual_f), Long.toString(l)}));
        }
        this._id_decl = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "id_decl", 0, 1, 0);
        this._id_decl_f = this._validator._integerValue;
        this._id_decl_ok = this._validator._attributeOK;
        this._venit_net_Rsursa = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "venit_net_Rsursa", 0, 1, 1);
        this._venit_net_Rsursa_f = this._validator._integerValue;
        this._venit_net_Rsursa_ok = this._validator._attributeOK;
        if (this._det_ven_net_f != 3L && this._forma_org_f != 1L && this._categ_venit_f != 1003L && this._venit_net_Rsursa_f > 0L) {
            this._validator.addError(1, "R49", "", this._validator.fillParams("Pt det_ven_net<>3 si forma_org<>1 si categ_venit<>1003 atunci venit_net_Rsursa(@0@) =0", new Object[]{Long.toString(this._venit_net_Rsursa_f)}));
        }
        this._castig = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "castig", 0, 1, 1);
        this._castig_f = this._validator._integerValue;
        this._castig_ok = this._validator._attributeOK;
        this._pierdere = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "pierdere", 0, 1, 1);
        this._pierdere_f = this._validator._integerValue;
        this._pierdere_ok = this._validator._attributeOK;
        if ((this._categ_venit_f != 1012L && this._categ_venit_f != 1001L || this._categ_venit_f == 1001L && this._det_ven_net_f != 3L) && this._castig_f > 0L) {
            this._validator.addError(1, "R50b", "", this._validator.fillParams("Pt (categ_venit not in (1001,1012) sau (categ_venit=1001 si det_ven_net<>3)  atunci castig=0", new Object[0]));
        }
        if (this._castig_f > 0L && this._pierdere_f > 0L) {
            this._validator.addError(1, "R50a", "", this._validator.fillParams("pierdere si castig nu pot fi simultan > 0", new Object[0]));
        }
        long l2 = -1L;
        if (this._pierdere_f > 0L && this._venit_net_anual_f > 0L) {
            this._validator.addError(1, "R51.2", "", this._validator.fillParams("pierdere si venit net anual nu pot fi simultan > 0", new Object[0]));
        }
        if ((this._categ_venit_f >= 1001L && this._categ_venit_f <= 1006L || this._categ_venit_f >= 1009L && this._categ_venit_f <= 1011L) && this._forma_org_f != 2L && this._forma_org_f != 3L) {
            if ((this._categ_venit_f >= 1001L && this._categ_venit_f <= 1003L || this._categ_venit_f >= 1009L && this._categ_venit_f <= 1011L) && this._det_ven_net_f == 1L) {
                l2 = this._venit_brut_f < this._chelt_deduc_f ? this._chelt_deduc_f - this._venit_brut_f : 0L;
            } else if (this._det_ven_net_f != 3L) {
                l2 = this._venit_brut_f < this._chelt_deduc_f ? this._chelt_deduc_f - this._venit_brut_f : 0L;
            }
        }
        if (this._categ_venit_f == 1013L) {
            l2 = 0L;
        }
        if (this._pierdere_f != l2 && l2 >= 0L) {
            this._validator.addError(1, "R51", "", this._validator.fillParams("pierdere(@0@) diferita de suma calculata (@1@) ", new Object[]{Long.toString(this._pierdere_f), Long.toString(l2)}));
        }
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        if (this._categ_venit_f == 1003L) {
            ++d212.is1003;
        }
        if (d212._d_rec_f == 1L && d212._rectif1_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 1 ( rectif1)", new Object[0]));
        }
        d212.nr_cap11 = 1L;
    }

    public void initialization() {
        this._scutire = null;
        this._scutire_f = 0L;
        this._scutire_ok = false;
        this._reg = null;
        this._reg_f = 0L;
        this._reg_ok = false;
        this._categ_venit = null;
        this._categ_venit_f = 0L;
        this._categ_venit_ok = false;
        this._det_ven_net = null;
        this._det_ven_net_f = 0L;
        this._det_ven_net_ok = false;
        this._forma_org = null;
        this._forma_org_f = 0L;
        this._forma_org_ok = false;
        this._caen = null;
        this._caen_f = 0L;
        this._caen_ok = false;
        this._descriere_sediu_bun = null;
        this._descriere_sediu_bun_ok = false;
        this._nr_doc_autoriz = null;
        this._nr_doc_autoriz_ok = false;
        this._data_doc_autoriz = null;
        this._data_doc_autoriz_ok = false;
        this._data_incep = null;
        this._data_incep_ok = false;
        this._data_sf = null;
        this._data_sf_ok = false;
        this._nr_zile_scutite = null;
        this._nr_zile_scutite_f = 0L;
        this._nr_zile_scutite_ok = false;
        this._cif_orgJN = null;
        this._cif_orgJN_f = 0L;
        this._cif_orgJN_ok = false;
        this._den_orgJN = null;
        this._den_orgJN_ok = false;
        this._venit_brut = null;
        this._venit_brut_f = 0L;
        this._venit_brut_ok = false;
        this._chelt_deduc = null;
        this._chelt_deduc_f = 0L;
        this._chelt_deduc_ok = false;
        this._venit_net_anual = null;
        this._venit_net_anual_f = 0L;
        this._venit_net_anual_ok = false;
        this._id_decl = null;
        this._id_decl_f = 0L;
        this._id_decl_ok = false;
        this._venit_net_Rsursa = null;
        this._venit_net_Rsursa_f = 0L;
        this._venit_net_Rsursa_ok = false;
        this._castig = null;
        this._castig_f = 0L;
        this._castig_ok = false;
        this._pierdere = null;
        this._pierdere_f = 0L;
        this._pierdere_ok = false;
    }
}

