/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v0;

import d212validator.v0.D212;
import d212validator.v0.DataObjectRoot;
import d212validator.v0.ValidatorImpl;
import dec.DECConst;

public class Cap12
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP12 = 0;
    String _bifa_bursa;
    long _bifa_bursa_f;
    boolean _bifa_bursa_ok;
    String _suma_bursa;
    long _suma_bursa_f;
    boolean _suma_bursa_ok;
    String _contract_bursa;
    boolean _contract_bursa_ok;
    String _doc_plata_bursa;
    boolean _doc_plata_bursa_ok;
    String _bifa_entitate;
    long _bifa_entitate_f;
    boolean _bifa_entitate_ok;
    String _suma_entitate;
    long _suma_entitate_f;
    boolean _suma_entitate_ok;
    String _den_entitate;
    boolean _den_entitate_ok;
    String _cif_entitate;
    long _cif_entitate_f;
    boolean _cif_entitate_ok;
    String _cont_entitate;
    boolean _cont_entitate_ok;

    public Cap12(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._bifa_bursa = this._validator.nextAttributeInInterval(0L, 1L, "bifa_bursa", 0, 1, 0);
        this._bifa_bursa_f = this._validator._integerValue;
        this._bifa_bursa_ok = this._validator._attributeOK;
        this._suma_bursa = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma_bursa", 0, 1, 0);
        this._suma_bursa_f = this._validator._integerValue;
        this._suma_bursa_ok = this._validator._attributeOK;
        this._contract_bursa = this._validator.nextAttribute("contract_bursa", 150, 4, 0);
        this._contract_bursa_ok = this._validator._attributeOK;
        this._doc_plata_bursa = this._validator.nextAttribute("doc_plata_bursa", 150, 4, 0);
        this._doc_plata_bursa_ok = this._validator._attributeOK;
        this._bifa_entitate = this._validator.nextAttributeInInterval(0L, 1L, "bifa_entitate", 0, 1, 1);
        this._bifa_entitate_f = this._validator._integerValue;
        this._bifa_entitate_ok = this._validator._attributeOK;
        this._suma_entitate = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma_entitate", 0, 1, 0);
        this._suma_entitate_f = this._validator._integerValue;
        this._suma_entitate_ok = this._validator._attributeOK;
        this._den_entitate = this._validator.nextAttribute("den_entitate", 250, 4, 0);
        this._den_entitate_ok = this._validator._attributeOK;
        this._cif_entitate = this._validator.nextAttributeAsCif("cif_entitate", 0);
        this._cif_entitate_f = this._validator._integerValue;
        this._cif_entitate_ok = this._validator._attributeOK;
        this._cont_entitate = this._validator.nextAttribute("cont_entitate", 24, 4, 0);
        this._cont_entitate_ok = this._validator._attributeOK;
        if (this._cont_entitate != null && this._validator.checkIban(this._cont_entitate) < 0) {
            this._validator.addError(1, "R_IBAN_cap12", "cont IBAN incorect", this._validator.fillParams("cont IBAN entitate = @0@ este incorect", new Object[]{this._cont_entitate}));
        }
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        if (d212._d_rec_f == 1L && d212._rectif1_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 1 ( rectif1)", new Object[0]));
        }
        if (this._bifa_bursa_f == 1L && (this._suma_bursa == null || this._contract_bursa == null)) {
            this._validator.addError(1, "R54", "", this._validator.fillParams("Daca bifa_bursa=1 atunci suma_bursa<>null si contract_bursa<>null", new Object[0]));
        }
        if (this._bifa_entitate_f == 1L && (this._cif_entitate == null || this._cont_entitate == null)) {
            this._validator.addError(1, "R54", "", this._validator.fillParams("Daca bifa_entitate=1 atunci cif_entitate<>null sicont_entitate<>null", new Object[0]));
        }
        d212.nr_cap12 = 1L;
    }

    public void initialization() {
        this._bifa_bursa = null;
        this._bifa_bursa_f = 0L;
        this._bifa_bursa_ok = false;
        this._suma_bursa = null;
        this._suma_bursa_f = 0L;
        this._suma_bursa_ok = false;
        this._contract_bursa = null;
        this._contract_bursa_ok = false;
        this._doc_plata_bursa = null;
        this._doc_plata_bursa_ok = false;
        this._bifa_entitate = null;
        this._bifa_entitate_f = 0L;
        this._bifa_entitate_ok = false;
        this._suma_entitate = null;
        this._suma_entitate_f = 0L;
        this._suma_entitate_ok = false;
        this._den_entitate = null;
        this._den_entitate_ok = false;
        this._cif_entitate = null;
        this._cif_entitate_f = 0L;
        this._cif_entitate_ok = false;
        this._cont_entitate = null;
        this._cont_entitate_ok = false;
    }
}

