/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v0;

import d212validator.v0.D212;
import d212validator.v0.DataObjectRoot;
import d212validator.v0.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Cap21
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP21 = 0;
    String _estr_categ_venit;
    long _estr_categ_venit_f;
    boolean _estr_categ_venit_ok;
    String _estr_det_ven_net;
    long _estr_det_ven_net_f;
    boolean _estr_det_ven_net_ok;
    String _estr_forma_org;
    long _estr_forma_org_f;
    boolean _estr_forma_org_ok;
    String _estr_caen;
    long _estr_caen_f;
    boolean _estr_caen_ok;
    String _estr_descriere_sediu_bun;
    boolean _estr_descriere_sediu_bun_ok;
    String _estr_nr_doc_autoriz;
    long _estr_nr_doc_autoriz_f;
    boolean _estr_nr_doc_autoriz_ok;
    String _estr_data_doc_autoriz;
    boolean _estr_data_doc_autoriz_ok;
    String _estr_data_incep;
    boolean _estr_data_incep_ok;
    String _estr_data_sf;
    boolean _estr_data_sf_ok;
    String _estr_nr_zile_scutite;
    long _estr_nr_zile_scutite_f;
    boolean _estr_nr_zile_scutite_ok;
    String _estr_venit_brut;
    long _estr_venit_brut_f;
    boolean _estr_venit_brut_ok;
    String _estr_chelt_deduc;
    long _estr_chelt_deduc_f;
    boolean _estr_chelt_deduc_ok;
    String _estr_venit_net;
    long _estr_venit_net_f;
    boolean _estr_venit_net_ok;
    String _estr_impozit_venit;
    long _estr_impozit_venit_f;
    boolean _estr_impozit_venit_ok;
    Date _estr_data_doc_autoriz_f;
    Date _estr_data_incep_f;
    Date _estr_data_sf_f;
    String _estr_venit_impozit;
    long _estr_venit_impozit_f;
    boolean _estr_venit_impozit_ok;

    public Cap21(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._estr_categ_venit = this._validator.nextAttributeInList(this._params._categ_venit21_type, "estr_categ_venit", 0, 1, 1);
        this._estr_categ_venit_f = this._validator._integerValue;
        this._estr_categ_venit_ok = this._validator._attributeOK;
        this._estr_det_ven_net = this._validator.nextAttributeInInterval(1L, 2L, "estr_det_ven_net", 0, 1, 1);
        this._estr_det_ven_net_f = this._validator._integerValue;
        this._estr_det_ven_net_ok = this._validator._attributeOK;
        this._estr_forma_org = this._validator.nextAttributeInInterval(1L, 4L, "estr_forma_org", 0, 1, 0);
        this._estr_forma_org_f = this._validator._integerValue;
        this._estr_forma_org_ok = this._validator._attributeOK;
        this._estr_caen = this._validator.nextAttributeInList(this._params._caenList, "estr_caen", 256, 4, 0);
        this._estr_caen_f = this._validator._integerValue;
        this._estr_caen_ok = this._validator._attributeOK;
        this._estr_descriere_sediu_bun = this._validator.nextAttribute("estr_descriere_sediu_bun", 200, 4, 0);
        this._estr_descriere_sediu_bun_ok = this._validator._attributeOK;
        this._estr_nr_doc_autoriz = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_nr_doc_autoriz", 0, 1, 0);
        this._estr_nr_doc_autoriz_f = this._validator._integerValue;
        this._estr_nr_doc_autoriz_ok = this._validator._attributeOK;
        this._estr_data_doc_autoriz = this._validator.nextAttribute("estr_data_doc_autoriz", 0, 3, 0);
        this._estr_data_doc_autoriz_f = this._validator._dateValue;
        this._estr_data_doc_autoriz_ok = this._validator._attributeOK;
        this._estr_data_incep = this._validator.nextAttribute("estr_data_incep", 0, 3, 0);
        this._estr_data_incep_f = this._validator._dateValue;
        this._estr_data_incep_ok = this._validator._attributeOK;
        this._estr_data_sf = this._validator.nextAttribute("estr_data_sf", 0, 3, 0);
        this._estr_data_sf_f = this._validator._dateValue;
        this._estr_data_sf_ok = this._validator._attributeOK;
        this._estr_nr_zile_scutite = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "estr_nr_zile_scutite", 0, 1, 0);
        this._estr_nr_zile_scutite_f = this._validator._integerValue;
        this._estr_nr_zile_scutite_ok = this._validator._attributeOK;
        this._estr_venit_brut = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_venit_brut", 0, 1, 1);
        this._estr_venit_brut_f = this._validator._integerValue;
        this._estr_venit_brut_ok = this._validator._attributeOK;
        this._estr_chelt_deduc = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_chelt_deduc", 0, 1, 1);
        this._estr_chelt_deduc_f = this._validator._integerValue;
        this._estr_chelt_deduc_ok = this._validator._attributeOK;
        this._estr_venit_net = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_venit_net", 0, 1, 1);
        this._estr_venit_net_f = this._validator._integerValue;
        this._estr_venit_net_ok = this._validator._attributeOK;
        this._estr_venit_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_venit_impozit", 0, 1, 1);
        this._estr_venit_impozit_f = this._validator._integerValue;
        this._estr_venit_impozit_ok = this._validator._attributeOK;
        this._estr_impozit_venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_impozit_venit", 0, 1, 1);
        this._estr_impozit_venit_f = this._validator._integerValue;
        this._estr_impozit_venit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        long l;
        D212 d212 = (D212)this._parent;
        if (d212._d_rec_f == 1L && d212._rectif2_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 2 ( rectif2)", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1001L || this._estr_categ_venit_f == 1002L || this._estr_categ_venit_f == 1004L || this._estr_categ_venit_f == 1006L || this._estr_categ_venit_f == 1006L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_det_ven_net_f != 1L) {
            this._validator.addError(1, "R81", "", this._validator.fillParams("Daca estr_categ_venit in (1001,1002,1004,1006,1009,1010,1011) atunci estr_det_ven_net=1", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1001L || this._estr_categ_venit_f == 1002L || this._estr_categ_venit_f == 1003L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_forma_org_f == 0L) {
            this._validator.addError(1, "R82a", "", this._validator.fillParams("Daca estr_categ_venit in (1001,1002,1003,1009,1010,1011) atunci estr_forma_org <> null", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1003L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_forma_org_f > 2L) {
            this._validator.addError(1, "R82b", "", this._validator.fillParams("Daca estr_categ_venit in (1003,1009,1010,1011) atunci estr_forma_org not in (3,4)", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1001L || this._estr_categ_venit_f == 1002L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_caen == null) {
            this._validator.addError(1, "R83", "", this._validator.fillParams("Daca estr_categ_venit in (1001,1002,1009,1010,1011) atunci estr_caen <> null", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1001L || this._estr_categ_venit_f == 1002L || this._estr_categ_venit_f == 1005L || this._estr_categ_venit_f == 1006L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_descriere_sediu_bun == null) {
            this._validator.addError(1, "R84", "", this._validator.fillParams("Daca estr_categ_venit in (1001,1002,1003,1005,1006,1009,1010,1011) atunci estr_descriere_sediu_bun <> null", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1001L || this._estr_categ_venit_f == 1002L || this._estr_categ_venit_f == 1005L) && this._estr_nr_doc_autoriz == null) {
            this._validator.addError(1, "R85", "", this._validator.fillParams("Daca estr_categ_venit in (1001,1002,1005) atunci estr_nr_doc_autoriz <> null", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1001L || this._estr_categ_venit_f == 1002L || this._estr_categ_venit_f == 1005L) && this._estr_data_doc_autoriz == null) {
            this._validator.addError(1, "R86", "", this._validator.fillParams("Daca estr_categ_venit in (1001,1002,1005) atunci estr_data_doc_autoriz <> null", new Object[0]));
        }
        if (this._estr_data_incep_ok && this._estr_data_sf_ok && this._estr_data_incep != null && this._estr_data_sf != null && this._estr_data_sf_f.before(this._estr_data_incep_f)) {
            this._validator.addError(1, "R87", "", this._validator.fillParams("estr_data_sf nu poate fi anterioara _estr_data_incep", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1004L || this._estr_categ_venit_f == 1005L || this._estr_categ_venit_f == 1006L) && this._estr_nr_zile_scutite != null) {
            this._validator.addError(1, "R89a", "", this._validator.fillParams("Daca estr_categ_venit in (1004,1005,1006) atunci estr_nr_zile_scutite = null", new Object[0]));
        }
        if (this._estr_nr_zile_scutite_f > 365L) {
            this._validator.addError(1, "R89b", "", this._validator.fillParams("Daca estr_nr_zile_scutite trebuie sa fie mai mic decat 366", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1003L || this._estr_categ_venit_f == 1005L) && this._estr_det_ven_net_f == 2L && this._estr_chelt_deduc_f != Math.round(0.4 * (double)this._estr_venit_brut_f)) {
            this._validator.addError(1, "R92", "", this._validator.fillParams("Daca estr_categ_venit in (1003,1005) si estr_det_ven_net=2, atunci estr_chelt_deduc = Round(0.4* estr_venit_brut)", new Object[0]));
        }
        long l2 = 0L;
        if (this._estr_det_ven_net_f != 1L || this._estr_forma_org_f != 2L) {
            if (this._estr_venit_brut_f > this._estr_chelt_deduc_f) {
                l2 = this._estr_venit_brut_f - this._estr_chelt_deduc_f;
            }
            if (this._estr_venit_net_f != l2) {
                this._validator.addError(1, "R93", "", this._validator.fillParams("estr_venit_net(@0@) diferit de suma calculata(@1@)", new Object[]{Long.toString(this._estr_venit_net_f), Long.toString(l2)}));
            }
        }
        if (this._estr_venit_impozit_f != (l = this._estr_venit_net_f - Math.round((double)(this._estr_venit_net_f * this._estr_nr_zile_scutite_f) / 365.0))) {
            this._validator.addError(1, "R94a", "", this._validator.fillParams("estr_venit_impozit(@0@) diferit de suma calculata(@1@)", new Object[]{Long.toString(this._estr_venit_impozit_f), Long.toString(l)}), 0);
        }
        if (this._estr_impozit_venit_f != Math.round(0.1 * (double)this._estr_venit_impozit_f)) {
            this._validator.addError(1, "R94b", "", this._validator.fillParams("estr_impozit_venit(@0@) diferit de suma calculata(@1@)", new Object[]{Long.toString(this._estr_impozit_venit_f), Long.toString(Math.round(0.1 * (double)this._estr_venit_impozit_f))}));
        }
        d212.nr_cap21 = 1L;
    }

    public void initialization() {
        this._estr_categ_venit = null;
        this._estr_categ_venit_f = 0L;
        this._estr_categ_venit_ok = false;
        this._estr_det_ven_net = null;
        this._estr_det_ven_net_f = 0L;
        this._estr_det_ven_net_ok = false;
        this._estr_forma_org = null;
        this._estr_forma_org_f = 0L;
        this._estr_forma_org_ok = false;
        this._estr_caen = null;
        this._estr_caen_f = 0L;
        this._estr_caen_ok = false;
        this._estr_descriere_sediu_bun = null;
        this._estr_data_doc_autoriz_f = null;
        this._estr_descriere_sediu_bun_ok = false;
        this._estr_nr_doc_autoriz = null;
        this._estr_nr_doc_autoriz_f = 0L;
        this._estr_nr_doc_autoriz_ok = false;
        this._estr_data_doc_autoriz = null;
        this._estr_data_doc_autoriz_ok = false;
        this._estr_data_doc_autoriz_f = null;
        this._estr_data_incep = null;
        this._estr_data_incep_f = null;
        this._estr_data_incep_ok = false;
        this._estr_data_sf = null;
        this._estr_data_sf_ok = false;
        this._estr_nr_zile_scutite = null;
        this._estr_nr_zile_scutite_f = 0L;
        this._estr_nr_zile_scutite_ok = false;
        this._estr_venit_impozit = null;
        this._estr_venit_impozit_f = 0L;
        this._estr_venit_impozit_ok = false;
        this._estr_venit_brut = null;
        this._estr_venit_brut_f = 0L;
        this._estr_venit_brut_ok = false;
        this._estr_chelt_deduc = null;
        this._estr_chelt_deduc_f = 0L;
        this._estr_chelt_deduc_ok = false;
        this._estr_venit_net = null;
        this._estr_venit_net_f = 0L;
        this._estr_venit_net_ok = false;
        this._estr_impozit_venit = null;
        this._estr_impozit_venit_f = 0L;
        this._estr_impozit_venit_ok = false;
    }
}

