/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v0;

import d212validator.v0.D212;
import d212validator.v0.DataObjectRoot;
import d212validator.v0.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Cap22
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP22 = 0;
    String _estn_categ_venit;
    long _estn_categ_venit_f;
    boolean _estn_categ_venit_ok;
    String _estn_nr_camere;
    long _estn_nr_camere_f;
    boolean _estn_nr_camere_ok;
    String _estn_forma_org;
    long _estn_forma_org_f;
    boolean _estn_forma_org_ok;
    String _estn_caen;
    long _estn_caen_f;
    boolean _estn_caen_ok;
    String _estn_descriere_sediu_bun;
    long _estn_descriere_sediu_bun_f;
    boolean _estn_descriere_sediu_bun_ok;
    String _estn_nr_doc_autoriz;
    long _estn_nr_doc_autoriz_f;
    boolean _estn_nr_doc_autoriz_ok;
    String _estn_data_doc_autoriz;
    Date _estn_data_doc_autoriz_f;
    Date _estn_data_incep_f;
    Date _estn_data_sf_f;
    boolean _estn_data_doc_autoriz_ok;
    String _estn_data_incep;
    boolean _estn_data_incep_ok;
    String _estn_data_sf;
    boolean _estn_data_sf_ok;
    String _estn_nr_zile_scutite;
    long _estn_nr_zile_scutite_f;
    boolean _estn_nr_zile_scutite_ok;
    String _estn_norma_venit;
    long _estn_norma_venit_f;
    boolean _estn_norma_venit_ok;
    String _estn_ajustare;
    long _estn_ajustare_f;
    boolean _estn_ajustare_ok;
    String _estn_venit_net_anual;
    long _estn_venit_net_anual_f;
    boolean _estn_venit_net_anual_ok;
    String _estn_impozit;
    long _estn_impozit_f;
    boolean _estn_impozit_ok;
    String _estn_venit_impozit;
    long _estn_venit_impozit_f;
    boolean _estn_venit_impozit_ok;

    public Cap22(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._estn_categ_venit = this._validator.nextAttributeInList(this._params._categ_venit22_type, "estn_categ_venit", 0, 1, 1);
        this._estn_categ_venit_f = this._validator._integerValue;
        this._estn_categ_venit_ok = this._validator._attributeOK;
        this._estn_nr_camere = this._validator.nextAttributeInInterval(1L, 5L, "estn_nr_camere", 0, 1, 0);
        this._estn_nr_camere_f = this._validator._integerValue;
        this._estn_nr_camere_ok = this._validator._attributeOK;
        this._estn_forma_org = this._validator.nextAttributeInInterval(1L, 2L, "estn_forma_org", 0, 1, 1);
        this._estn_forma_org_f = this._validator._integerValue;
        this._estn_forma_org_ok = this._validator._attributeOK;
        this._estn_caen = this._validator.nextAttributeInList(this._params._caenList, "estn_caen", 256, 4, 0);
        this._estn_caen_f = this._validator._integerValue;
        this._estn_caen_ok = this._validator._attributeOK;
        this._estn_descriere_sediu_bun = this._validator.nextAttribute("estn_descriere_sediu_bun", 250, 4, 1);
        this._estn_descriere_sediu_bun_ok = this._validator._attributeOK;
        this._estn_nr_doc_autoriz = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_nr_doc_autoriz", 0, 1, 0);
        this._estn_nr_doc_autoriz_f = this._validator._integerValue;
        this._estn_nr_doc_autoriz_ok = this._validator._attributeOK;
        this._estn_data_doc_autoriz = this._validator.nextAttribute("estn_data_doc_autoriz", 0, 3, 0);
        this._estn_data_doc_autoriz_f = this._validator._dateValue;
        this._estn_data_doc_autoriz_ok = this._validator._attributeOK;
        this._estn_data_incep = this._validator.nextAttribute("estn_data_incep", 0, 3, 0);
        this._estn_data_incep_f = this._validator._dateValue;
        this._estn_data_incep_ok = this._validator._attributeOK;
        this._estn_data_sf = this._validator.nextAttribute("estn_data_sf", 0, 3, 0);
        this._estn_data_sf_f = this._validator._dateValue;
        this._estn_data_sf_ok = this._validator._attributeOK;
        this._estn_nr_zile_scutite = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "estn_nr_zile_scutite", 0, 1, 0);
        this._estn_nr_zile_scutite_f = this._validator._integerValue;
        this._estn_nr_zile_scutite_ok = this._validator._attributeOK;
        this._estn_norma_venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_norma_venit", 0, 1, 1);
        this._estn_norma_venit_f = this._validator._integerValue;
        this._estn_norma_venit_ok = this._validator._attributeOK;
        this._estn_ajustare = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_ajustare", 0, 1, 1);
        this._estn_ajustare_f = this._validator._integerValue;
        this._estn_ajustare_ok = this._validator._attributeOK;
        this._estn_venit_net_anual = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_venit_net_anual", 0, 1, 1);
        this._estn_venit_net_anual_f = this._validator._integerValue;
        this._estn_venit_net_anual_ok = this._validator._attributeOK;
        this._estn_venit_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_venit_impozit", 0, 1, 1);
        this._estn_venit_impozit_f = this._validator._integerValue;
        this._estn_venit_impozit_ok = this._validator._attributeOK;
        this._estn_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_impozit", 0, 1, 1);
        this._estn_impozit_f = this._validator._integerValue;
        this._estn_impozit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        long l;
        D212 d212 = (D212)this._parent;
        if (d212._d_rec_f == 1L && d212._rectif2_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 2 ( rectif2)", new Object[0]));
        }
        if (this._estn_categ_venit_f == 1006L && this._estn_nr_camere_f == 0L) {
            this._validator.addError(1, "R99", "", this._validator.fillParams("Daca estn_categ_venit=1006 atunci estn_nr_camere > 0", new Object[0]));
        }
        if (this._estn_categ_venit_f == 1006L && this._estn_nr_camere_f == 0L) {
            this._validator.addError(1, "R99", "", this._validator.fillParams("Daca estn_categ_venit=1006 atunci estn_nr_camere > 0", new Object[0]));
        }
        if (this._estn_categ_venit_f == 1001L && this._estn_caen == null) {
            this._validator.addError(1, "R102", "", this._validator.fillParams("Daca estn_categ_venit=1001 atunci estn_caen <> null", new Object[0]));
        }
        if (this._estn_categ_venit_f == 1001L && (this._estn_nr_doc_autoriz == null || this._estn_data_doc_autoriz == null)) {
            this._validator.addError(1, "R104", "", this._validator.fillParams("Daca estn_categ_venit=1001 atunci estn_nr_doc_autoriz <> null si estn_data_doc_autoriz <> null", new Object[0]));
        }
        if (this._estn_data_sf != null && this._estn_data_incep != null && this._estn_data_sf_f.before(this._estn_data_incep_f)) {
            this._validator.addError(1, "R106", "", this._validator.fillParams("Daca estn_categ_venit=1001 atunci estn_nr_doc_autoriz <> null si estn_data_doc_autoriz <> null", new Object[0]));
        }
        if (this._estn_categ_venit_f != 1001L && this._estn_nr_zile_scutite != null) {
            this._validator.addError(1, "R108a", "", this._validator.fillParams("Daca estn_categ_venit<>1001 atunci estn_nr_zile_scutite = null", new Object[0]));
        }
        if (this._estn_nr_zile_scutite_f > 365L) {
            this._validator.addError(1, "R108b", "", this._validator.fillParams(" estn_nr_zile_scutite trebuie sa fie mai mic decat 366", new Object[0]));
        }
        if (this._estn_venit_impozit_f != (l = this._estn_venit_net_anual_f - Math.round((double)(this._estn_venit_net_anual_f * this._estn_nr_zile_scutite_f) / 365.0))) {
            this._validator.addError(1, "R113", "", this._validator.fillParams("estn_venit_impozit(@0@) diferit de suma calculata(@1@)", new Object[]{Long.toString(this._estn_venit_impozit_f), Long.toString(l)}), 0);
        }
        if (this._estn_impozit_f != Math.round(0.1 * (double)this._estn_venit_impozit_f)) {
            this._validator.addError(1, "R113", "", this._validator.fillParams("estn_venit_impozit(@0@) diferit de suma calculata(@1@)", new Object[]{Long.toString(this._estn_impozit_f), Long.toString(Math.round(0.1 * (double)this._estn_venit_impozit_f))}));
        }
        d212.nr_cap22 = 1L;
    }

    public void initialization() {
        this._estn_categ_venit = null;
        this._estn_categ_venit_f = 0L;
        this._estn_categ_venit_ok = false;
        this._estn_nr_camere = null;
        this._estn_nr_camere_f = 0L;
        this._estn_nr_camere_ok = false;
        this._estn_forma_org = null;
        this._estn_forma_org_f = 0L;
        this._estn_forma_org_ok = false;
        this._estn_caen = null;
        this._estn_caen_f = 0L;
        this._estn_caen_ok = false;
        this._estn_descriere_sediu_bun = null;
        this._estn_descriere_sediu_bun_ok = false;
        this._estn_data_doc_autoriz_f = null;
        this._estn_data_incep_f = null;
        this._estn_data_sf_f = null;
        this._estn_nr_doc_autoriz = null;
        this._estn_nr_doc_autoriz_f = 0L;
        this._estn_nr_doc_autoriz_ok = false;
        this._estn_data_doc_autoriz = null;
        this._estn_data_doc_autoriz_ok = false;
        this._estn_data_incep = null;
        this._estn_data_incep_ok = false;
        this._estn_data_sf = null;
        this._estn_data_sf_ok = false;
        this._estn_nr_zile_scutite = null;
        this._estn_nr_zile_scutite_f = 0L;
        this._estn_nr_zile_scutite_ok = false;
        this._estn_norma_venit = null;
        this._estn_norma_venit_f = 0L;
        this._estn_norma_venit_ok = false;
        this._estn_ajustare = null;
        this._estn_ajustare_f = 0L;
        this._estn_ajustare_ok = false;
        this._estn_venit_net_anual = null;
        this._estn_venit_net_anual_f = 0L;
        this._estn_venit_net_anual_ok = false;
        this._estn_impozit = null;
        this._estn_impozit_f = 0L;
        this._estn_impozit_ok = false;
        this._estn_venit_impozit = null;
        this._estn_venit_impozit_f = 0L;
        this._estn_venit_impozit_ok = false;
    }
}

