/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v0;

import d212validator.v0.D212;
import d212validator.v0.DataObjectRoot;
import d212validator.v0.ProdusInfo;
import d212validator.v0.ValidatorImpl;
import dec.DECConst;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Cap23
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP23 = 0;
    List<ProdusInfo> _prod;
    String _estan_forma_org;
    long _estan_forma_org_f;
    boolean _estan_forma_org_ok;
    String _estan_nr_contr;
    boolean _estan_nr_contr_ok;
    String _estan_data_contr;
    boolean _estan_data_contr_ok;
    String _estan_zile_scutire;
    long _estan_zile_scutire_f;
    boolean _estan_zile_scutire_ok;
    String _estan_judet_activ;
    boolean _estan_judet_activ_ok;
    String _estan_loc_activ;
    boolean _estan_loc_activ_ok;
    String _estan_incadrare_neimpoz;
    long _estan_incadrare_neimpoz_f;
    boolean _estan_incadrare_neimpoz_ok;
    Date _estan_data_contr_f;

    public Cap23(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._estan_forma_org = this._validator.nextAttributeInInterval(1L, 2L, "estan_forma_org", 0, 1, 1);
        this._estan_forma_org_f = this._validator._integerValue;
        this._estan_forma_org_ok = this._validator._attributeOK;
        this._estan_nr_contr = this._validator.nextAttribute("estan_nr_contr", 15, 4, 0);
        this._estan_nr_contr_ok = this._validator._attributeOK;
        this._estan_data_contr = this._validator.nextAttribute("estan_data_contr", 0, 3, 0);
        this._estan_data_contr_f = this._validator._dateValue;
        this._estan_data_contr_ok = this._validator._attributeOK;
        this._estan_zile_scutire = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "estan_zile_scutire", 0, 1, 0);
        this._estan_zile_scutire_f = this._validator._integerValue;
        this._estan_zile_scutire_ok = this._validator._attributeOK;
        this._estan_judet_activ = this._validator.nextAttributeInList(this._params._judete, "estan_judet_activ", 256, 4, 1);
        this._estan_judet_activ_ok = this._validator._attributeOK;
        this._estan_loc_activ = this._validator.nextAttribute("estan_loc_activ", 30, 4, 1);
        this._estan_loc_activ_ok = this._validator._attributeOK;
        this._estan_incadrare_neimpoz = this._validator.nextAttributeInInterval(0L, 1L, "estan_incadrare_neimpoz", 0, 1, 1);
        this._estan_incadrare_neimpoz_f = this._validator._integerValue;
        this._estan_incadrare_neimpoz_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        if (d212._d_rec_f == 1L && d212._rectif2_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 2 ( rectif2)", new Object[0]));
        }
        if (this._estan_forma_org_f == 2L && (this._estan_nr_contr == null || this._estan_data_contr == null)) {
            this._validator.addError(1, "R120", "", this._validator.fillParams("Daca estan_forma_org=2 atunci estan_nr_contr <>null si estan_data_ctr<>null", new Object[0]));
        }
        if (this._estan_zile_scutire_f > 365L) {
            this._validator.addError(1, "R122", "", this._validator.fillParams("estan_zile_scutire trebuie sa fie mai mic decat 366", new Object[0]));
        }
        if (this._validator._cntProduse == 0 && this._estan_forma_org_f == 1L) {
            this._validator.addError(1, "R126", "", this._validator.fillParams("Daca estan_forma_org=1 atunci sectiunea de produse trebuie sa aiba minim o aparitie (@0@)", new Object[]{Long.toString(this._validator._cntProduse)}));
        }
        d212.nr_cap23 = 1L;
    }

    public void initialization() {
        this._prod = new ArrayList<ProdusInfo>();
        this._estan_forma_org = null;
        this._estan_forma_org_f = 0L;
        this._estan_forma_org_ok = false;
        this._estan_nr_contr = null;
        this._estan_nr_contr_ok = false;
        this._estan_data_contr = null;
        this._estan_data_contr_ok = false;
        this._estan_zile_scutire = null;
        this._estan_zile_scutire_f = 0L;
        this._estan_zile_scutire_ok = false;
        this._estan_judet_activ = null;
        this._estan_judet_activ_ok = false;
        this._estan_loc_activ = null;
        this._estan_loc_activ_ok = false;
        this._estan_incadrare_neimpoz = null;
        this._estan_incadrare_neimpoz_f = 0L;
        this._estan_incadrare_neimpoz_ok = false;
        this._estan_data_contr_f = null;
    }
}

