/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v0;

import d212validator.v0.DataObjectRoot;
import d212validator.v0.ValidatorImpl;
import dec.DECConst;

public class D212
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_D212 = 0;
    String _an_r;
    long _an_r_f;
    boolean _an_r_ok;
    String _luna_r;
    long _luna_r_f;
    boolean _luna_r_ok;
    String _cif;
    long _cif_f;
    boolean _cif_ok;
    String _d_rec;
    long _d_rec_f;
    boolean _d_rec_ok;
    String _rectif1;
    long _rectif1_f;
    boolean _rectif1_ok;
    String _rectif2;
    long _rectif2_f;
    boolean _rectif2_ok;
    String _nume_c;
    boolean _nume_c_ok;
    String _initiala_c;
    boolean _initiala_c_ok;
    String _prenume_c;
    boolean _prenume_c_ok;
    String _adresa_c;
    boolean _adresa_c_ok;
    String _telefon_c;
    boolean _telefon_c_ok;
    String _email_c;
    boolean _email_c_ok;
    String _nerezident;
    long _nerezident_f;
    boolean _nerezident_ok;
    String _stat_rezidenta;
    boolean _stat_rezidenta_ok;
    String _cif_str;
    boolean _cif_str_ok;
    String _cont_bancar;
    boolean _cont_bancar_ok;
    String _den_i;
    boolean _den_i_ok;
    String _cif_i;
    long _cif_i_f;
    boolean _cif_i_ok;
    String _adresa_i;
    boolean _adresa_i_ok;
    String _telefon_i;
    boolean _telefon_i_ok;
    String _fax_i;
    boolean _fax_i_ok;
    String _email_i;
    boolean _email_i_ok;
    long nr_cap11;
    long nr_cap12;
    long nr_cap13;
    long nr_cap21;
    long nr_cap22;
    long nr_cap23;
    long nr_d212_oblig;
    String _totalPlata_A;
    long _totalPlata_A_f;
    boolean _totalPlata_A_ok;
    long val;
    long is1003;

    public D212(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._an_r = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_4, "an_r", 0, 1, 1);
        this._an_r_f = this._validator._integerValue;
        this._an_r_ok = this._validator._attributeOK;
        this._luna_r = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_2, "luna_r", 0, 1, 1);
        this._luna_r_f = this._validator._integerValue;
        this._luna_r_ok = this._validator._attributeOK;
        if (this._validator._extractValuesFlag == 1) {
            return;
        }
        this._cif = this._validator.nextAttributeAsNif("cif", 1);
        this._cif_f = this._validator._integerValue;
        this._cif_ok = this._validator._attributeOK;
        if (this._an_r_f != 2018L) {
            this._validator.addError(1, "RAn", "", this._validator.fillParams("An raportare nepermis. Se permite doar an = 2018 ", new Object[0]));
        }
        if (this._luna_r_f != 12L) {
            this._validator.addError(1, "RLuna", "", this._validator.fillParams("Luna raportare improprie", new Object[0]));
        }
        this._d_rec = this._validator.nextAttributeInInterval(0L, 1L, "d_rec", 0, 1, 1);
        this._d_rec_f = this._validator._integerValue;
        this._d_rec_ok = this._validator._attributeOK;
        this._rectif1 = this._validator.nextAttributeInInterval(0L, 1L, "rectif1", 0, 1, 1);
        this._rectif1_f = this._validator._integerValue;
        this._rectif1_ok = this._validator._attributeOK;
        this._rectif2 = this._validator.nextAttributeInInterval(0L, 1L, "rectif2", 0, 1, 1);
        this._rectif2_f = this._validator._integerValue;
        this._rectif2_ok = this._validator._attributeOK;
        if (this._d_rec_f == 0L && this._rectif1_f + this._rectif2_f > 0L || this._d_rec_f == 1L && this._rectif1_f + this._rectif2_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata cel putin una dintre cele 2 bife de rectificative", new Object[0]));
        }
        this._nume_c = this._validator.nextAttribute("nume_c", 75, 4, 1);
        this._nume_c_ok = this._validator._attributeOK;
        if (this._nume_c != null && this._nume_c.length() < 2) {
            this._validator.addError(1, "Rnume_c", "", this._validator.fillParams("Nume contribuabil trebuie sa aiba o lungime mai mare de 2 caractere", new Object[0]));
        }
        this._initiala_c = this._validator.nextAttribute("initiala_c", 2, 4, 0);
        this._initiala_c_ok = this._validator._attributeOK;
        this._prenume_c = this._validator.nextAttribute("prenume_c", 75, 4, 1);
        this._prenume_c_ok = this._validator._attributeOK;
        if (this._prenume_c != null && this._prenume_c.length() < 2) {
            this._validator.addError(1, "Rprenume_c", "", this._validator.fillParams("Prenume contribuabil trebuie sa aiba o lungime mai mare de 2 caractere", new Object[0]));
        }
        this._adresa_c = this._validator.nextAttribute("adresa_c", 200, 4, 1);
        this._adresa_c_ok = this._validator._attributeOK;
        this._telefon_c = this._validator.nextAttribute("telefon_c", 15, 4, 0);
        this._telefon_c_ok = this._validator._attributeOK;
        this._email_c = this._validator.nextAttribute("email_c", 200, 4, 0);
        this._email_c_ok = this._validator._attributeOK;
        this._nerezident = this._validator.nextAttributeInInterval(0L, 1L, "nerezident", 0, 1, 1);
        this._nerezident_f = this._validator._integerValue;
        this._nerezident_ok = this._validator._attributeOK;
        this._cif_str = this._validator.nextAttribute("cif_str", 30, 4, 0);
        this._cif_str_ok = this._validator._attributeOK;
        this._stat_rezidenta = this._validator.nextAttributeInList(this._params._state, "stat_rezidenta", 256, 4, 0);
        this._stat_rezidenta_ok = this._validator._attributeOK;
        if (this._nerezident_f == 1L && this._stat_rezidenta == null) {
            this._validator.addError(1, "Nerezident", "", this._validator.fillParams("Pentru nerezidenti statul de rezidenta este obligatoriu", new Object[0]));
        }
        if (this._nerezident_f == 0L && this._stat_rezidenta != null) {
            this._validator.addError(1, "Nerezident", "", this._validator.fillParams("Pentru persoanele care nu sunt nerezidente statul de rezidenta trebuie sa fie null", new Object[0]));
        }
        if (this._nerezident_f == 0L && this._cif_str != null) {
            this._validator.addError(1, "CIF Nerezident", "", this._validator.fillParams("Pentru persoanele care nu sunt nerezidente CIF-ul din statul de rezidenta trebuie sa fie null", new Object[0]));
        }
        if (this._nerezident_f == 1L && this._cif_str == null) {
            this._validator.addError(1, "CIF Nerezident", "", this._validator.fillParams("Pentru persoanele care sunt nerezidente CIF-ul din statul de rezidenta este obligatoriu", new Object[0]));
        }
        this._cont_bancar = this._validator.nextAttribute("cont_bancar", 24, 4, 0);
        this._cont_bancar_ok = this._validator._attributeOK;
        if (this._cont_bancar != null && this._validator.checkIban(this._cont_bancar) < 0) {
            this._validator.addError(1, "R_IBAN", "cont IBAN incorect", this._validator.fillParams("cont IBAN = @0@ este incorect", new Object[]{this._cont_bancar}));
        }
        this._den_i = this._validator.nextAttribute("den_i", 60, 4, 0);
        this._den_i_ok = this._validator._attributeOK;
        this._cif_i = this._validator.nextAttributeAsCif("cif_i", 0);
        this._cif_i_f = this._validator._integerValue;
        this._cif_i_ok = this._validator._attributeOK;
        this._adresa_i = this._validator.nextAttribute("adresa_i", 200, 4, 0);
        this._adresa_i_ok = this._validator._attributeOK;
        this._telefon_i = this._validator.nextAttribute("telefon_i", 15, 4, 0);
        this._telefon_i_ok = this._validator._attributeOK;
        this._fax_i = this._validator.nextAttribute("fax_i", 15, 4, 0);
        this._fax_i_ok = this._validator._attributeOK;
        this._email_i = this._validator.nextAttribute("email_i", 200, 4, 0);
        this._email_i_ok = this._validator._attributeOK;
        this._totalPlata_A = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "totalPlata_A", 0, 1, 1);
        this._totalPlata_A_f = this._validator._integerValue;
        this._totalPlata_A_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        if (this._totalPlata_A_f != this.val) {
            this._validator.addError(1, "RsumaControl", "", this._validator.fillParams("totalPlata_A (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(this._totalPlata_A_f), Long.toString(this.val)}));
        }
        if (this.is1003 > 1L) {
            this._validator.addError(1, "Rcap11", "", this._validator.fillParams("categ_venit=1003 nu poate avea aparitii multiple in sectiunea cap11", new Object[0]));
        }
        if (this._rectif1_f + this._rectif2_f == 0L && this.nr_cap11 + this.nr_cap12 + this.nr_cap13 + this.nr_cap21 + this.nr_cap22 + this.nr_cap23 + this.nr_d212_oblig == 0L) {
            this._validator.addError(1, "Rdec", "", this._validator.fillParams("declaratia nu contine date in niciun capitol", new Object[0]));
        }
    }

    public void initialization() {
        this._an_r = null;
        this._an_r_f = 0L;
        this._an_r_ok = false;
        this._luna_r = null;
        this._luna_r_f = 0L;
        this._luna_r_ok = false;
        this._cif = null;
        this._cif_f = 0L;
        this._cif_ok = false;
        this._d_rec = null;
        this._d_rec_f = 0L;
        this._d_rec_ok = false;
        this._rectif1 = null;
        this._rectif1_f = 0L;
        this._rectif1_ok = false;
        this._rectif2 = null;
        this._rectif2_f = 0L;
        this._rectif2_ok = false;
        this.nr_cap11 = 0L;
        this.nr_cap12 = 0L;
        this.nr_cap13 = 0L;
        this.nr_cap21 = 0L;
        this.nr_cap22 = 0L;
        this.nr_cap23 = 0L;
        this.nr_d212_oblig = 0L;
        this._nume_c = null;
        this._nume_c_ok = false;
        this._initiala_c = null;
        this._initiala_c_ok = false;
        this._prenume_c = null;
        this._prenume_c_ok = false;
        this._adresa_c = null;
        this._adresa_c_ok = false;
        this._telefon_c = null;
        this._telefon_c_ok = false;
        this._email_c = null;
        this._email_c_ok = false;
        this._nerezident = null;
        this._nerezident_f = 0L;
        this._nerezident_ok = false;
        this._stat_rezidenta = null;
        this._stat_rezidenta_ok = false;
        this._cif_str = null;
        this._cif_str_ok = false;
        this._cont_bancar = null;
        this._cont_bancar_ok = false;
        this._den_i = null;
        this._den_i_ok = false;
        this._cif_i = null;
        this._cif_i_f = 0L;
        this._cif_i_ok = false;
        this._adresa_i = null;
        this._adresa_i_ok = false;
        this._telefon_i = null;
        this._telefon_i_ok = false;
        this._fax_i = null;
        this._fax_i_ok = false;
        this._email_i = null;
        this._email_i_ok = false;
        this._totalPlata_A = null;
        this._totalPlata_A_f = 0L;
        this._totalPlata_A_ok = false;
        this.val = 0L;
        this.is1003 = 0L;
    }
}

