/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v0;

import d212validator.v0.Cap23;
import d212validator.v0.DataObjectRoot;
import d212validator.v0.ProdusInfo;
import d212validator.v0.ValidatorImpl;
import dec.DECConst;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Produse
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_PRODUSE = 0;
    String _codp;
    long _codp_f;
    boolean _codp_ok;
    String _nr_unit_total;
    double _nr_unit_total_f;
    boolean _nr_unit_total_ok;
    String _nr_unit_neimpoz;
    double _nr_unit_neimpoz_f;
    boolean _nr_unit_neimpoz_ok;
    String _nr_unit_impoz;
    double _nr_unit_impoz_f;
    boolean _nr_unit_impoz_ok;
    String _norma_agr;
    double _norma_agr_f;
    boolean _norma_agr_ok;
    String _venit_impozabil;
    long _venit_impozabil_f;
    boolean _venit_impozabil_ok;
    String _norma_agr_redusa;
    long _norma_agr_redusa_f;
    boolean _norma_agr_redusa_ok;

    public Produse(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._codp = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "codp", 0, 1, 0);
        this._codp_f = this._validator._integerValue;
        this._codp_ok = this._validator._attributeOK;
        if (this._codp_f < 101L && this._codp_f > 113L && this._codp_f < 201L || this._codp_f > 207L) {
            this._validator.addError(1, "Cod produs", "", this._validator.fillParams("Cod produs valoare incorecta", new Object[0]));
        }
        this._nr_unit_total = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "nr_unit_total", 0);
        this._nr_unit_total_f = this._validator._realValue;
        this._nr_unit_total_ok = this._validator._attributeOK;
        this._nr_unit_neimpoz = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "nr_unit_neimpoz", 0);
        this._nr_unit_neimpoz_f = this._validator._realValue;
        this._nr_unit_neimpoz_ok = this._validator._attributeOK;
        this._nr_unit_impoz = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "nr_unit_impoz", 0);
        this._nr_unit_impoz_f = this._validator._realValue;
        this._nr_unit_impoz_ok = this._validator._attributeOK;
        this._norma_agr = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "norma_agr", 0);
        this._norma_agr_f = this._validator._realValue;
        this._norma_agr_ok = this._validator._attributeOK;
        this._norma_agr_redusa = this._validator.nextAttributeDblPattern(0.0, null, 15, 2, "norma_agr_redusa", 0);
        this._norma_agr_redusa_f = this._validator._integerValue;
        this._norma_agr_redusa_ok = this._validator._attributeOK;
        this._venit_impozabil = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "venit_impozabil", 0, 1, 0);
        this._venit_impozabil_f = this._validator._integerValue;
        this._venit_impozabil_ok = this._validator._attributeOK;
        Cap23 cap23 = (Cap23)this._parent;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        Cap23 cap23 = (Cap23)this._parent;
        if (cap23._estan_forma_org_f == 1L && (this._codp == null || this._nr_unit_total == null || this._nr_unit_neimpoz == null || this._nr_unit_impoz == null || this._norma_agr == null || this._venit_impozabil == null)) {
            this._validator.addError(1, "R produse", "", this._validator.fillParams("Daca estan_forma_org = 1 atunci codp, nr_unit_total, nr_unit_neimpoz, nr_unit_impoz, norma_agr, venit_impozabil trebuie completate", new Object[0]));
        }
        ProdusInfo produsInfo = null;
        produsInfo = new ProdusInfo();
        produsInfo._codp = this._validator._produse._codp;
        produsInfo._nr_unit_total = this._validator._produse._nr_unit_total;
        produsInfo._nr_unit_neimpoz = this._validator._produse._nr_unit_neimpoz;
        produsInfo._nr_unit_impoz = this._validator._produse._nr_unit_impoz;
        produsInfo._norma_agr = this._validator._produse._norma_agr;
        produsInfo._venit_impozabil = this._validator._produse._venit_impozabil;
        produsInfo._norma_agr_redusa = this._validator._produse._norma_agr_redusa;
        this._validator._cap23[this._validator._cntCap23]._prod.add(produsInfo);
        double d = 0.0;
        if (this._nr_unit_total_f > this._nr_unit_neimpoz_f) {
            d = this._nr_unit_total_f - this._nr_unit_neimpoz_f;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
        if (cap23._estan_forma_org_f == 1L && this._nr_unit_impoz_f != bigDecimal.doubleValue()) {
            this._validator.addError(1, "R130", "", this._validator.fillParams("nr_unit_impoz (@0@) diferit de suma calculata (@1@)", new Object[]{Double.toString(this._nr_unit_impoz_f), Double.toString(bigDecimal.doubleValue())}));
        }
    }

    public void initialization() {
        this._codp = null;
        this._codp_f = 0L;
        this._codp_ok = false;
        this._nr_unit_total = null;
        this._nr_unit_total_f = 0.0;
        this._nr_unit_total_ok = false;
        this._nr_unit_neimpoz = null;
        this._nr_unit_neimpoz_f = 0.0;
        this._nr_unit_neimpoz_ok = false;
        this._nr_unit_impoz = null;
        this._nr_unit_impoz_f = 0.0;
        this._nr_unit_impoz_ok = false;
        this._norma_agr = null;
        this._norma_agr_f = 0.0;
        this._norma_agr_ok = false;
        this._norma_agr_redusa = null;
        this._norma_agr_redusa_f = 0L;
        this._norma_agr_redusa_ok = false;
        this._venit_impozabil = null;
        this._venit_impozabil_f = 0L;
        this._venit_impozabil_ok = false;
    }
}

