/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v1;

import d212validator.v1.D212;
import d212validator.v1.DataObjectRoot;
import d212validator.v1.ValidatorImpl;
import dec.DECConst;

public class Cap13
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP13 = 0;
    String _den_orgJN;
    boolean _den_orgJN_ok;
    String _cif_orgJN;
    boolean _cif_orgJN_ok;
    String _joc_venit_brut;
    long _joc_venit_brut_f;
    boolean _joc_venit_brut_ok;
    String _joc_impozit;
    long _joc_impozit_f;
    boolean _joc_impozit_ok;
    String _categ_venit_13;
    long _categ_venit_13_f;
    boolean _categ_venit_13_ok;

    public Cap13(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._den_orgJN = this._validator.nextAttribute("den_orgJN", 250, 4, 1);
        this._den_orgJN_ok = this._validator._attributeOK;
        this._cif_orgJN = this._validator.nextAttribute("cif_orgJN", 10, 4, 1);
        this._cif_orgJN_ok = this._validator._attributeOK;
        this._joc_venit_brut = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "joc_venit_brut", 0, 1, 1);
        this._joc_venit_brut_f = this._validator._integerValue;
        this._joc_venit_brut_ok = this._validator._attributeOK;
        this._joc_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "joc_impozit", 0, 1, 1);
        this._joc_impozit_f = this._validator._integerValue;
        this._joc_impozit_ok = this._validator._attributeOK;
        this._categ_venit_13 = this._validator.nextAttributeInList(this._params._categ_venit, "categ_venit_13", 4, 1, 0);
        this._categ_venit_13_f = this._validator._integerValue;
        this._categ_venit_13_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        d212.nr_cap13 = 1L;
        if (d212._d_rec_f == 1L && d212._rectif1_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 1 ( rectif1)", new Object[0]));
        }
        d212.joc_impozit += this._joc_impozit_f;
        long l = Math.round(0.01 * (double)this._joc_venit_brut_f);
        if (this._joc_venit_brut_f <= 66750L && this._joc_impozit_f != l) {
            this._validator.addError(1, "R118", "", this._validator.fillParams("Daca joc_venit_brut <= 66.750, atunci joc_impozit = math.round(joc_venit_brut* 1/ 100)", new Object[0]));
        }
        l = Math.round(667.5 + ((double)this._joc_venit_brut_f - 66750.0) * 0.16);
        if (this._joc_venit_brut_f > 66750L && this._joc_venit_brut_f <= 445000L && this._joc_impozit_f != l) {
            this._validator.addError(1, "R118", "", this._validator.fillParams("Daca 66.750 < joc_venit_brut <= 445.000, atunci joc_impozit = math.round(667,5 +( joc_venit_brut - 66.750)* 16/ 100)", new Object[0]));
        }
        l = Math.round(61187.5 + ((double)this._joc_venit_brut_f - 445000.0) * 0.25);
        if (this._joc_venit_brut_f > 445000L && this._joc_impozit_f != l) {
            this._validator.addError(1, "R118", "", this._validator.fillParams("Daca joc_venit_brut (@0@) > 445.000, atunci joc_impozit (@1@) = math.round(61187,5 + ( joc_venit_brut - 445.000)* 25/ 100) (@2@)", new Object[]{Long.toString(this._joc_venit_brut_f), Long.toString(this._joc_impozit_f), Long.toString(l)}));
        }
    }

    public void initialization() {
        this._den_orgJN = null;
        this._den_orgJN_ok = false;
        this._cif_orgJN = null;
        this._cif_orgJN_ok = false;
        this._joc_venit_brut = null;
        this._joc_venit_brut_f = 0L;
        this._joc_venit_brut_ok = false;
        this._joc_impozit = null;
        this._joc_impozit_f = 0L;
        this._joc_impozit_ok = false;
        this._categ_venit_13 = null;
        this._categ_venit_13_f = 0L;
        this._categ_venit_13_ok = false;
    }
}

