/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v1;

import d212validator.v1.D212;
import d212validator.v1.DataObjectRoot;
import d212validator.v1.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Cap21
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP21 = 0;
    String _estr_categ_venit;
    long _estr_categ_venit_f;
    boolean _estr_categ_venit_ok;
    String _estr_bifa_chirie;
    long _estr_bifa_chirie_f;
    boolean _estr_bifa_chirie_ok;
    String _estr_det_ven_net;
    long _estr_det_ven_net_f;
    boolean _estr_det_ven_net_ok;
    String _estr_forma_org;
    long _estr_forma_org_f;
    boolean _estr_forma_org_ok;
    String _estr_mod_forma_org;
    long _estr_mod_forma_org_f;
    boolean _estr_mod_forma_org_ok;
    String _estr_caen;
    boolean _estr_caen_ok;
    String _estr_descriere_sediu_bun;
    boolean _estr_descriere_sediu_bun_ok;
    String _estr_nr_doc_autoriz;
    boolean _estr_nr_doc_autoriz_ok;
    String _estr_data_doc_autoriz;
    Date _estr_data_doc_autoriz_f;
    boolean _estr_data_doc_autoriz_ok;
    String _estr_data_incep;
    Date _estr_data_incep_f;
    boolean _estr_data_incep_ok;
    String _estr_data_sf;
    Date _estr_data_sf_f;
    boolean _estr_data_sf_ok;
    String _estr_data_susp;
    Date _estr_data_susp_f;
    boolean _estr_data_susp_ok;
    String _estr_nr_zile_scutite;
    long _estr_nr_zile_scutite_f;
    boolean _estr_nr_zile_scutite_ok;
    String _estr_venit_brut;
    long _estr_venit_brut_f;
    boolean _estr_venit_brut_ok;
    String _estr_chelt_deduc;
    long _estr_chelt_deduc_f;
    boolean _estr_chelt_deduc_ok;
    String _estr_venit_net;
    long _estr_venit_net_f;
    boolean _estr_venit_net_ok;
    String _estr_venit_impozit;
    long _estr_venit_impozit_f;
    boolean _estr_venit_impozit_ok;
    String _estr_impozit_venit;
    long _estr_impozit_venit_f;
    boolean _estr_impozit_venit_ok;

    public Cap21(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._estr_categ_venit = this._validator.nextAttributeInList(this._params._estr_categ_venit, "estr_categ_venit", 0, 1, 1);
        this._estr_categ_venit_f = this._validator._integerValue;
        this._estr_categ_venit_ok = this._validator._attributeOK;
        this._estr_bifa_chirie = this._validator.nextAttributeInInterval(1L, 2L, "estr_bifa_chirie", 0, 1, 0);
        this._estr_bifa_chirie_f = this._validator._integerValue;
        this._estr_bifa_chirie_ok = this._validator._attributeOK;
        this._estr_det_ven_net = this._validator.nextAttributeInInterval(1L, 2L, "estr_det_ven_net", 0, 1, 1);
        this._estr_det_ven_net_f = this._validator._integerValue;
        this._estr_det_ven_net_ok = this._validator._attributeOK;
        this._estr_forma_org = this._validator.nextAttributeInInterval(1L, 3L, "estr_forma_org", 0, 1, 0);
        this._estr_forma_org_f = this._validator._integerValue;
        this._estr_forma_org_ok = this._validator._attributeOK;
        this._estr_mod_forma_org = this._validator.nextAttributeInInterval(0L, 1L, "estr_mod_forma_org", 0, 1, 0);
        this._estr_mod_forma_org_f = this._validator._integerValue;
        this._estr_mod_forma_org_ok = this._validator._attributeOK;
        this._estr_caen = this._validator.nextAttributeInList(this._params._listaCaen, "estr_caen", 4, 4, 0);
        this._estr_caen_ok = this._validator._attributeOK;
        this._estr_descriere_sediu_bun = this._validator.nextAttribute("estr_descriere_sediu_bun", 200, 4, 0);
        this._estr_descriere_sediu_bun_ok = this._validator._attributeOK;
        this._estr_nr_doc_autoriz = this._validator.nextAttribute("estr_nr_doc_autoriz", 15, 4, 0);
        this._estr_nr_doc_autoriz_ok = this._validator._attributeOK;
        this._estr_data_doc_autoriz = this._validator.nextAttribute("estr_data_doc_autoriz", 0, 3, 0);
        this._estr_data_doc_autoriz_f = this._validator._dateValue;
        this._estr_data_doc_autoriz_ok = this._validator._attributeOK;
        this._estr_data_incep = this._validator.nextAttribute("estr_data_incep", 0, 3, 0);
        this._estr_data_incep_f = this._validator._dateValue;
        this._estr_data_incep_ok = this._validator._attributeOK;
        this._estr_data_sf = this._validator.nextAttribute("estr_data_sf", 0, 3, 0);
        this._estr_data_sf_f = this._validator._dateValue;
        this._estr_data_sf_ok = this._validator._attributeOK;
        this._estr_data_susp = this._validator.nextAttribute("estr_data_susp", 0, 3, 0);
        this._estr_data_susp_f = this._validator._dateValue;
        this._estr_data_susp_ok = this._validator._attributeOK;
        this._estr_nr_zile_scutite = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "estr_nr_zile_scutite", 0, 1, 0);
        this._estr_nr_zile_scutite_f = this._validator._integerValue;
        this._estr_nr_zile_scutite_ok = this._validator._attributeOK;
        this._estr_venit_brut = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_venit_brut", 0, 1, 0);
        this._estr_venit_brut_f = this._validator._integerValue;
        this._estr_venit_brut_ok = this._validator._attributeOK;
        this._estr_chelt_deduc = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_chelt_deduc", 0, 1, 0);
        this._estr_chelt_deduc_f = this._validator._integerValue;
        this._estr_chelt_deduc_ok = this._validator._attributeOK;
        this._estr_venit_net = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_venit_net", 0, 1, 1);
        this._estr_venit_net_f = this._validator._integerValue;
        this._estr_venit_net_ok = this._validator._attributeOK;
        this._estr_venit_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_venit_impozit", 0, 1, 1);
        this._estr_venit_impozit_f = this._validator._integerValue;
        this._estr_venit_impozit_ok = this._validator._attributeOK;
        this._estr_impozit_venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estr_impozit_venit", 0, 1, 1);
        this._estr_impozit_venit_f = this._validator._integerValue;
        this._estr_impozit_venit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        long l;
        D212 d212 = (D212)this._parent;
        String string = null;
        d212.nr_cap21 = 1L;
        if (d212._d_rec_f == 1L && d212._rectif2_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 2 ( rectif2)", new Object[0]));
        }
        d212.estr_impozit_venit += this._estr_impozit_venit_f;
        if (this._estr_categ_venit_f == 1015L && this._estr_det_ven_net_f == 2L && this._estr_bifa_chirie == null) {
            this._validator.addError(1, "R138", "", this._validator.fillParams("Daca estr_categ_venit = 1015 si estr_det_ven_net = 2, atunci estr_bifa_chirie trebuie sa existe", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1016L || this._estr_categ_venit_f == 1004L || this._estr_categ_venit_f == 1006L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_det_ven_net_f != 1L) {
            this._validator.addError(1, "R139", "", this._validator.fillParams("Pt estr_categ_venit (1016,1004,1006,1009,1010,1011), atunci estr_det_ven_net =1", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1016L || this._estr_categ_venit_f == 1003L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_forma_org == null) {
            this._validator.addError(1, "R140", "", this._validator.fillParams("Pt estr_categ_venit (1016,1003,1009,1010,1011), estr_forma_org este obligatoriu", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1003L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_forma_org_f == 3L) {
            this._validator.addError(1, "R140.1", "", this._validator.fillParams("Pt estr_categ_venit (1003,1009, 1010, 1011), atunci estr_forma_org <>3", new Object[0]));
        }
        if (this._estr_categ_venit_f != 1016L && this._estr_mod_forma_org_f != 0L) {
            this._validator.addError(1, "R141.1", "", this._validator.fillParams("Pt estr_categ_venit <> (1016), estr_mod_forma_org =0", new Object[0]));
        }
        if (this._estr_categ_venit_f == 1016L && this._estr_caen == null) {
            this._validator.addError(1, "R142", "", this._validator.fillParams("Pt estr_categ_venit 1016 atunci estr_caen <>null", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1016L || this._estr_categ_venit_f == 1015L || this._estr_categ_venit_f == 1004L || this._estr_categ_venit_f == 1009L || this._estr_categ_venit_f == 1010L || this._estr_categ_venit_f == 1011L) && this._estr_descriere_sediu_bun == null) {
            this._validator.addError(1, "R143", "", this._validator.fillParams("Pt estr_categ_venit (1016,1015,1004,1009,1010,1011), atunci estr_descriere_sediu_bun <>null", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1015L || this._estr_forma_org_f == 2L) && this._estr_data_doc_autoriz != null && this._estr_nr_doc_autoriz == null) {
            this._validator.addError(1, "R144", "", this._validator.fillParams("Pt estr_categ_venit 1015 sau estr_forma_org=2 si estr_data_doc_autoriz <> null, atunci estr_nr_doc_autoriz <>null", new Object[0]));
        }
        if (this._estr_categ_venit_f == 1016L && this._estr_nr_doc_autoriz != null && this._estr_data_doc_autoriz == null) {
            this._validator.addError(1, "R145", "", this._validator.fillParams("Pt estr_categ_venit 1016 si estr_nr_doc_autoriz <> null, atunci estr_data_doc_autoriz <>null", new Object[0]));
        }
        if (this._estr_data_incep_ok && this._estr_data_sf_ok && this._estr_data_incep != null && this._estr_data_sf != null && this._estr_data_sf_f.before(this._estr_data_incep_f)) {
            this._validator.addError(1, "R146", "", this._validator.fillParams("Data sfarsit nu poate fi anterioara datei de inceput", new Object[0]));
        }
        if ((this._estr_categ_venit_f == 1015L || this._estr_categ_venit_f == 1004L || this._estr_categ_venit_f == 1006L) && this._estr_nr_zile_scutite != null) {
            this._validator.addError(1, "R149", "", this._validator.fillParams("Pt estr_categ_venit 1015,1004,1006, atunci estr_nr_zile_scutite =null", new Object[0]));
        }
        if (this._estr_forma_org_f != 2L && this._estr_categ_venit_f == 1003L && this._estr_det_ven_net_f == 2L && this._estr_venit_brut == null) {
            this._validator.addError(1, "R150", "", this._validator.fillParams("Daca estr_categ_venit =1003 si estr_det_venit=2 atunci estr_venit_brut=null", new Object[0]));
        }
        if (this._estr_forma_org_f == 2L && this._estr_categ_venit_f != 1003L && this._estr_det_ven_net_f != 2L && this._estr_chelt_deduc != null && this._estr_chelt_deduc_f != (l = Math.round(0.4 * (double)this._estr_venit_brut_f))) {
            this._validator.addError(1, "R151", "", this._validator.fillParams("Daca estr_forma_org =2 atunci estr_chelt_deduc=null", new Object[0]));
        }
        if (this._estr_forma_org_f == 2L && this._estr_chelt_deduc != null) {
            l = Math.round(0.4 * (double)this._estr_venit_brut_f);
            if (this._estr_categ_venit_f == 1003L && this._estr_det_ven_net_f == 2L && this._estr_chelt_deduc_f != l) {
                this._validator.addError(1, "R152", "", this._validator.fillParams("Daca estr_categ_venit =1003 si estr_det_ven_net=2 atunci estr_chelt_deduc=40/100 * estr_venit_brut", new Object[0]));
            }
        }
        if (this._estr_forma_org_f == 1L && this._estr_venit_net_f != this._estr_venit_brut_f - this._estr_chelt_deduc_f) {
            this._validator.addError(1, "R152", "", this._validator.fillParams("Daca estr_forma_org =1 atunci estr_venit_net = estr_venit_brut - estr_chelt_deduc", new Object[0]));
        }
        if (this._estr_venit_brut != null || this._estr_chelt_deduc != null) {
            if (this._estr_forma_org_f == 1L && this._estr_venit_net_f != this._estr_venit_brut_f - this._estr_chelt_deduc_f) {
                this._validator.addError(1, "R92", "", this._validator.fillParams("Daca est_venit_net_anual <> null atunci est_venit_net_anual (@2@)= est_venit_brut(@0@) - est_chelt_deduc(@1@)", new Object[]{Long.toString(this._estr_venit_brut_f), Long.toString(this._estr_chelt_deduc_f), Long.toString(this._estr_venit_net_f)}));
            } else if (this._estr_venit_net == null) {
                this._validator.addError(1, "R92", "", this._validator.fillParams("Daca estr_venit_net <> null atunci est_venit_net_anual (@2@)= est_venit_brut(@0@) - est_chelt_deduc(@1@)", new Object[]{Long.toString(this._estr_venit_brut_f), Long.toString(this._estr_chelt_deduc_f), Long.toString(this._estr_venit_net_f)}));
            }
        }
        if (this._estr_nr_zile_scutite == null && this._estr_venit_impozit_f != this._estr_venit_net_f) {
            this._validator.addError(1, "R153", "", this._validator.fillParams("Daca estr_nr_zile_scutite = null atunci estr_venit_impozit = estr_venit_net", new Object[0]));
        }
        if (this._estr_nr_zile_scutite != null && this._estr_venit_impozit_f >= this._estr_venit_net_f) {
            this._validator.addError(1, "R153.1", "", this._validator.fillParams("Daca estr_nr_zile_scutite <> null atunci estr_venit_impozit < estr_venit_net", new Object[0]));
        }
        if (this._estr_impozit_venit_f != (l = Math.round(0.1 * (double)this._estr_venit_impozit_f))) {
            this._validator.addError(1, "R154", "", this._validator.fillParams("estr_impozit_venit = 10/100 * estr_venit_impozit", new Object[0]));
        }
        if (this._estr_categ_venit != null && this._estr_nr_doc_autoriz != null && this._estr_data_doc_autoriz != null) {
            string = this._estr_categ_venit + "|" + this._estr_nr_doc_autoriz + "|" + this._estr_data_doc_autoriz;
            if (d212._listaPerechiEstrCategVenit.contains(string)) {
                this._validator.addError(1, "RUnicitate", "ERR \u2013 nu puteti avea mai multe aparitii pentru perechea (estr_categ_venit+estr_nr_doc_autoriz+estr_data_doc_autoriz)", this._validator.fillParams("tripletul (estr_categ_venit (@0@), estr_nr_doc_autoriz (@1@), estr_data_doc_autoriz (@2@)) nu este unic", new Object[]{Long.toString(this._estr_categ_venit_f), this._estr_nr_doc_autoriz, this._estr_data_doc_autoriz}));
            } else {
                d212._listaPerechiEstrCategVenit.add(string);
            }
        }
    }

    public void initialization() {
        this._estr_categ_venit = null;
        this._estr_categ_venit_f = 0L;
        this._estr_categ_venit_ok = false;
        this._estr_bifa_chirie = null;
        this._estr_bifa_chirie_f = 0L;
        this._estr_bifa_chirie_ok = false;
        this._estr_det_ven_net = null;
        this._estr_det_ven_net_f = 0L;
        this._estr_det_ven_net_ok = false;
        this._estr_forma_org = null;
        this._estr_forma_org_f = 0L;
        this._estr_forma_org_ok = false;
        this._estr_mod_forma_org = null;
        this._estr_mod_forma_org_f = 0L;
        this._estr_mod_forma_org_ok = false;
        this._estr_caen = null;
        this._estr_caen_ok = false;
        this._estr_descriere_sediu_bun = null;
        this._estr_descriere_sediu_bun_ok = false;
        this._estr_nr_doc_autoriz = null;
        this._estr_nr_doc_autoriz_ok = false;
        this._estr_data_doc_autoriz = null;
        this._estr_data_doc_autoriz_f = null;
        this._estr_data_doc_autoriz_ok = false;
        this._estr_data_incep = null;
        this._estr_data_incep_f = null;
        this._estr_data_incep_ok = false;
        this._estr_data_sf = null;
        this._estr_data_sf_f = null;
        this._estr_data_sf_ok = false;
        this._estr_data_susp = null;
        this._estr_data_susp_f = null;
        this._estr_data_susp_ok = false;
        this._estr_nr_zile_scutite = null;
        this._estr_nr_zile_scutite_f = 0L;
        this._estr_nr_zile_scutite_ok = false;
        this._estr_venit_brut = null;
        this._estr_venit_brut_f = 0L;
        this._estr_venit_brut_ok = false;
        this._estr_chelt_deduc = null;
        this._estr_chelt_deduc_f = 0L;
        this._estr_chelt_deduc_ok = false;
        this._estr_venit_net = null;
        this._estr_venit_net_f = 0L;
        this._estr_venit_net_ok = false;
        this._estr_venit_impozit = null;
        this._estr_venit_impozit_f = 0L;
        this._estr_venit_impozit_ok = false;
        this._estr_impozit_venit = null;
        this._estr_impozit_venit_f = 0L;
        this._estr_impozit_venit_ok = false;
    }
}

