/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v2;

import d212validator.v2.D212;
import d212validator.v2.DataObjectRoot;
import d212validator.v2.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Cap14
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP14 = 0;
    String _str_stat_realiz_v;
    boolean _str_stat_realiz_v_ok;
    String _str_categ_venit;
    long _str_categ_venit_f;
    boolean _str_categ_venit_ok;
    String _dubla_impunere;
    long _dubla_impunere_f;
    boolean _dubla_impunere_ok;
    String _str_data_incep;
    Date _str_data_incep_f;
    boolean _str_data_incep_ok;
    String _str_data_sf;
    Date _str_data_sf_f;
    boolean _str_data_sf_ok;
    String _str_venit_brut;
    long _str_venit_brut_f;
    boolean _str_venit_brut_ok;
    String _str_chelt_deduc;
    long _str_chelt_deduc_f;
    boolean _str_chelt_deduc_ok;
    String _str_venit_net_anual;
    long _str_venit_net_anual_f;
    boolean _str_venit_net_anual_ok;
    String _str_pierdere_anuala;
    long _str_pierdere_anuala_f;
    boolean _str_pierdere_anuala_ok;
    String _str_pierdere_precedenta;
    long _str_pierdere_precedenta_f;
    boolean _str_pierdere_precedenta_ok;
    String _str_venit_recalculat;
    long _str_venit_recalculat_f;
    boolean _str_venit_recalculat_ok;
    String _str_impozit_datorat_Ro;
    long _str_impozit_datorat_Ro_f;
    boolean _str_impozit_datorat_Ro_ok;
    String _str_impozit_platit;
    long _str_impozit_platit_f;
    boolean _str_impozit_platit_ok;
    String _str_credit_fiscal;
    long _str_credit_fiscal_f;
    boolean _str_credit_fiscal_ok;
    String _str_dif_impozit_datorat;
    long _str_dif_impozit_datorat_f;
    boolean _str_dif_impozit_datorat_ok;

    public Cap14(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._str_stat_realiz_v = this._validator.nextAttributeInList(this._params._nomenclatorTari, "str_stat_realiz_v", 256, 4, 1);
        this._str_stat_realiz_v_ok = this._validator._attributeOK;
        this._str_categ_venit = this._validator.nextAttributeInList(this._params._str_categ_venit, "str_categ_venit", 0, 1, 1);
        this._str_categ_venit_f = this._validator._integerValue;
        this._str_categ_venit_ok = this._validator._attributeOK;
        this._dubla_impunere = this._validator.nextAttributeInList(this._params._dubla_impunere, "dubla_impunere", 0, 1, 0);
        this._dubla_impunere_f = this._validator._integerValue;
        this._dubla_impunere_ok = this._validator._attributeOK;
        this._str_data_incep = this._validator.nextAttribute("str_data_incep", 0, 3, 0);
        this._str_data_incep_f = this._validator._dateValue;
        this._str_data_incep_ok = this._validator._attributeOK;
        this._str_data_sf = this._validator.nextAttribute("str_data_sf", 0, 3, 0);
        this._str_data_sf_f = this._validator._dateValue;
        this._str_data_sf_ok = this._validator._attributeOK;
        this._str_venit_brut = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_venit_brut", 0, 1, 0);
        this._str_venit_brut_f = this._validator._integerValue;
        this._str_venit_brut_ok = this._validator._attributeOK;
        this._str_chelt_deduc = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_chelt_deduc", 0, 1, 0);
        this._str_chelt_deduc_f = this._validator._integerValue;
        this._str_chelt_deduc_ok = this._validator._attributeOK;
        this._str_venit_net_anual = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_venit_net_anual", 0, 1, 0);
        this._str_venit_net_anual_f = this._validator._integerValue;
        this._str_venit_net_anual_ok = this._validator._attributeOK;
        this._str_pierdere_anuala = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_pierdere_anuala", 0, 1, 0);
        this._str_pierdere_anuala_f = this._validator._integerValue;
        this._str_pierdere_anuala_ok = this._validator._attributeOK;
        this._str_pierdere_precedenta = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_pierdere_precedenta", 0, 1, 0);
        this._str_pierdere_precedenta_f = this._validator._integerValue;
        this._str_pierdere_precedenta_ok = this._validator._attributeOK;
        this._str_venit_recalculat = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_venit_recalculat", 0, 1, 0);
        this._str_venit_recalculat_f = this._validator._integerValue;
        this._str_venit_recalculat_ok = this._validator._attributeOK;
        this._str_impozit_datorat_Ro = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_impozit_datorat_Ro", 0, 1, 0);
        this._str_impozit_datorat_Ro_f = this._validator._integerValue;
        this._str_impozit_datorat_Ro_ok = this._validator._attributeOK;
        this._str_impozit_platit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_impozit_platit", 0, 1, 0);
        this._str_impozit_platit_f = this._validator._integerValue;
        this._str_impozit_platit_ok = this._validator._attributeOK;
        this._str_credit_fiscal = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_credit_fiscal", 0, 1, 0);
        this._str_credit_fiscal_f = this._validator._integerValue;
        this._str_credit_fiscal_ok = this._validator._attributeOK;
        this._str_dif_impozit_datorat = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "str_dif_impozit_datorat", 0, 1, 0);
        this._str_dif_impozit_datorat_f = this._validator._integerValue;
        this._str_dif_impozit_datorat_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        d212.nr_cap14 = 1L;
        if (d212._d_rec_f == 1L && d212._rectif1_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 1 ( rectif1)", new Object[0]));
        }
        d212.str_dif_impozit_datorat += this._str_dif_impozit_datorat_f;
        if (this._str_data_incep != null && this._str_data_sf != null && this._str_data_sf_f.before(this._str_data_incep_f)) {
            this._validator.addError(1, "R125", "", this._validator.fillParams("Data sfarsit nu poate fi anterioara datei de inceput", new Object[0]));
        }
        if (this._str_venit_brut != null && (this._str_categ_venit_f == 2012L || this._str_categ_venit_f == 2016L)) {
            this._validator.addError(1, "R127", "", this._validator.fillParams("str_venit_brut (@0@) <> null <=> str_categ_venit <> (2012 || 2016)", new Object[]{Long.toString(this._str_venit_brut_f)}));
        }
        if ((this._str_categ_venit_f == 2012L || this._str_categ_venit_f == 2016L) && this._str_chelt_deduc != null) {
            this._validator.addError(1, "R128", "", this._validator.fillParams("str_chelt_deduc trebuie sa fie null pt str_categ_venit 2012 sau 2016", new Object[0]));
        }
        if ((this._str_categ_venit_f != 2012L || this._str_categ_venit_f != 2016L) && this._str_venit_brut_f - this._str_chelt_deduc_f > 0L && this._str_venit_net_anual_f != this._str_venit_brut_f - this._str_chelt_deduc_f) {
            this._validator.addError(1, "R129", "", this._validator.fillParams("Daca str_categ_venit <> (2012 || 2016), atunci ( daca (str_venit_brut - str_chelt_deduc > 0),str_venit_net_anual = str_venit_brut - str_chelt_deduc", new Object[0]));
        }
        if (this._str_pierdere_anuala_f > 0L && this._str_venit_net_anual != null) {
            this._validator.addError(1, "R129.1", "", this._validator.fillParams("str_pierdere_anuala  (@0@) trebuie sa fie null pt str_venit_net_anual = null", new Object[0]));
        }
        if (this._str_categ_venit_f == 2016L && this._str_pierdere_anuala != null && this._str_venit_brut_f - this._str_chelt_deduc_f > 0L && this._str_venit_net_anual_f != this._str_venit_brut_f - this._str_chelt_deduc_f) {
            this._validator.addError(1, "R129", "", this._validator.fillParams("Daca str_categ_venit <> (2012 || 2016), atunci ( daca (str_venit_brut - str_chelt_deduc > 0),str_venit_net_anual = str_venit_brut - str_chelt_deduc", new Object[0]));
        }
        if (this._str_pierdere_anuala_f > 0L && this._str_venit_net_anual != null) {
            this._validator.addError(1, "R129.1", "", this._validator.fillParams("str_pierdere_anuala  (@0@) trebuie sa fie null pt str_venit_net_anual = null", new Object[0]));
        }
        if (this._str_venit_net_anual_f - this._str_pierdere_precedenta_f > 0L && this._str_venit_recalculat_f != this._str_venit_net_anual_f - this._str_pierdere_precedenta_f) {
            this._validator.addError(1, "R132", "", this._validator.fillParams("(str_venit_recalculat  = str_venit_net_anual  - str_ pierdere_precedenta) <=> (str_venit_net_anual  - str_ pierdere_precedenta > 0", new Object[0]));
        }
        if (this._dubla_impunere_f == 2L && this._str_impozit_datorat_Ro_f != 0L) {
            this._validator.addError(1, "R133", "", this._validator.fillParams("Daca dubla_impunere = 2, atunci str_impozit_datorat_Ro (@0@) = 0", new Object[]{Long.toString(this._str_impozit_datorat_Ro_f)}));
        }
        if (this._str_impozit_datorat_Ro_f - this._str_credit_fiscal_f > 0L && this._str_dif_impozit_datorat_f != this._str_impozit_datorat_Ro_f - this._str_credit_fiscal_f) {
            this._validator.addError(1, "R136", "", this._validator.fillParams("str_dif_impozit_datorat  = str_impozit_datorat_Ro - str_credit_fiscal) <=> (str_impozit_datorat_Ro - str_credit_fiscal  > 0)", new Object[0]));
        }
    }

    public void initialization() {
        this._str_stat_realiz_v = null;
        this._str_stat_realiz_v_ok = false;
        this._str_categ_venit = null;
        this._str_categ_venit_f = 0L;
        this._str_categ_venit_ok = false;
        this._dubla_impunere = null;
        this._dubla_impunere_f = 0L;
        this._dubla_impunere_ok = false;
        this._str_data_incep = null;
        this._str_data_incep_f = null;
        this._str_data_incep_ok = false;
        this._str_data_sf = null;
        this._str_data_sf_f = null;
        this._str_data_sf_ok = false;
        this._str_venit_brut = null;
        this._str_venit_brut_f = 0L;
        this._str_venit_brut_ok = false;
        this._str_chelt_deduc = null;
        this._str_chelt_deduc_f = 0L;
        this._str_chelt_deduc_ok = false;
        this._str_venit_net_anual = null;
        this._str_venit_net_anual_f = 0L;
        this._str_venit_net_anual_ok = false;
        this._str_pierdere_anuala = null;
        this._str_pierdere_anuala_f = 0L;
        this._str_pierdere_anuala_ok = false;
        this._str_pierdere_precedenta = null;
        this._str_pierdere_precedenta_f = 0L;
        this._str_pierdere_precedenta_ok = false;
        this._str_venit_recalculat = null;
        this._str_venit_recalculat_f = 0L;
        this._str_venit_recalculat_ok = false;
        this._str_impozit_datorat_Ro = null;
        this._str_impozit_datorat_Ro_f = 0L;
        this._str_impozit_datorat_Ro_ok = false;
        this._str_impozit_platit = null;
        this._str_impozit_platit_f = 0L;
        this._str_impozit_platit_ok = false;
        this._str_credit_fiscal = null;
        this._str_credit_fiscal_f = 0L;
        this._str_credit_fiscal_ok = false;
        this._str_dif_impozit_datorat = null;
        this._str_dif_impozit_datorat_f = 0L;
        this._str_dif_impozit_datorat_ok = false;
    }
}

