/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v2;

import d212validator.v2.D212;
import d212validator.v2.DataObjectRoot;
import d212validator.v2.ProdusInfo_v1;
import d212validator.v2.ValidatorImpl;
import dec.DECConst;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Cap23
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP23 = 0;
    List<ProdusInfo_v1> _prod;
    String _estan_forma_org;
    long _estan_forma_org_f;
    boolean _estan_forma_org_ok;
    String _estan_nr_contr;
    boolean _estan_nr_contr_ok;
    String _estan_data_contr;
    Date _estan_data_contr_f;
    boolean _estan_data_contr_ok;
    String _estan_zile_scutire;
    long _estan_zile_scutire_f;
    boolean _estan_zile_scutire_ok;
    String _estan_judet_activ;
    boolean _estan_judet_activ_ok;
    String _estan_loc_activ;
    boolean _estan_loc_activ_ok;
    String _estan_incadrare_neimpoz;
    long _estan_incadrare_neimpoz_f;
    boolean _estan_incadrare_neimpoz_ok;
    String _estan_venit_distribuit;
    long _estan_venit_distribuit_f;
    boolean _estan_venit_distribuit_ok;

    public Cap23(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._estan_forma_org = this._validator.nextAttributeInInterval(1L, 2L, "estan_forma_org", 0, 1, 1);
        this._estan_forma_org_f = this._validator._integerValue;
        this._estan_forma_org_ok = this._validator._attributeOK;
        this._estan_nr_contr = this._validator.nextAttribute("estan_nr_contr", 15, 4, 0);
        this._estan_nr_contr_ok = this._validator._attributeOK;
        this._estan_data_contr = this._validator.nextAttribute("estan_data_contr", 0, 3, 0);
        this._estan_data_contr_f = this._validator._dateValue;
        this._estan_data_contr_ok = this._validator._attributeOK;
        this._estan_zile_scutire = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "estan_zile_scutire", 0, 1, 0);
        this._estan_zile_scutire_f = this._validator._integerValue;
        this._estan_zile_scutire_ok = this._validator._attributeOK;
        this._estan_judet_activ = this._validator.nextAttribute("estan_judet_activ", 2, 4, 1);
        this._estan_judet_activ_ok = this._validator._attributeOK;
        this._estan_loc_activ = this._validator.nextAttribute("estan_loc_activ", 30, 4, 1);
        this._estan_loc_activ_ok = this._validator._attributeOK;
        this._estan_incadrare_neimpoz = this._validator.nextAttributeInInterval(0L, 1L, "estan_incadrare_neimpoz", 0, 1, 0);
        this._estan_incadrare_neimpoz_f = this._validator._integerValue;
        this._estan_incadrare_neimpoz_ok = this._validator._attributeOK;
        this._estan_venit_distribuit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estan_venit_distribuit", 0, 1, 0);
        this._estan_venit_distribuit_f = this._validator._integerValue;
        this._estan_venit_distribuit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        d212.nr_cap23 = 1L;
        String string = null;
        if (d212._d_rec_f == 1L && d212._rectif2_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 2 ( rectif2)", new Object[0]));
        }
        if (this._estan_forma_org_f == 2L && this._estan_nr_contr == null) {
            this._validator.addError(1, "R176", "", this._validator.fillParams("Daca estan_forma_org= 2, atunci estan_nr_contr trebuie sa existe", new Object[0]));
        }
        if (this._estan_nr_contr != null && this._estan_data_contr == null) {
            this._validator.addError(1, "R177", "", this._validator.fillParams("Daca estan_nr_contr <> null  atunci si estan_data_contr trebuie sa existe", new Object[0]));
        }
        if (this._estan_forma_org_f == 2L && this._estan_venit_distribuit == null) {
            this._validator.addError(1, "R181", "", this._validator.fillParams("Daca estan_forma_org = 2  atunci si estan_venit_distribuit trebuie sa existe", new Object[0]));
        }
        if (this._estan_data_contr != null && this._estan_nr_contr != null) {
            string = this._estan_data_contr + "|" + this._estan_nr_contr;
            if (d212._listaPerechiEstanUnicitate.contains(string)) {
                this._validator.addError(1, "RUnicitate", "ERR \u2013 nu puteti avea mai multe aparitii pentru perechea (estan_data_contr + estan_nr_contr)", this._validator.fillParams("perechea (estan_data_contr (@0@), estan_nr_contr (@1@)) nu este unica", new Object[]{this._estan_data_contr, this._estan_nr_contr}));
            } else {
                d212._listaPerechiEstanUnicitate.add(string);
            }
        }
    }

    public void initialization() {
        this._prod = new ArrayList<ProdusInfo_v1>();
        this._estan_forma_org = null;
        this._estan_forma_org_f = 0L;
        this._estan_forma_org_ok = false;
        this._estan_nr_contr = null;
        this._estan_nr_contr_ok = false;
        this._estan_data_contr = null;
        this._estan_data_contr_f = null;
        this._estan_data_contr_ok = false;
        this._estan_zile_scutire = null;
        this._estan_zile_scutire_f = 0L;
        this._estan_zile_scutire_ok = false;
        this._estan_judet_activ = null;
        this._estan_judet_activ_ok = false;
        this._estan_loc_activ = null;
        this._estan_loc_activ_ok = false;
        this._estan_incadrare_neimpoz = null;
        this._estan_incadrare_neimpoz_f = 0L;
        this._estan_incadrare_neimpoz_ok = false;
        this._estan_venit_distribuit = null;
        this._estan_venit_distribuit_f = 0L;
        this._estan_venit_distribuit_ok = false;
    }
}

