/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v3;

import d212validator.v3.D212;
import d212validator.v3.DataObjectRoot;
import d212validator.v3.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Cap12
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP12 = 0;
    String _norma_categ_venit;
    long _norma_categ_venit_f;
    boolean _norma_categ_venit_ok;
    String _norma_nr_camere;
    long _norma_nr_camere_f;
    boolean _norma_nr_camere_ok;
    String _norma_forma_org;
    long _norma_forma_org_f;
    boolean _norma_forma_org_ok;
    String _norma_caen;
    boolean _norma_caen_ok;
    String _norma_descriere_sediu_bun;
    boolean _norma_descriere_sediu_bun_ok;
    String _norma_nr_doc_autoriz;
    boolean _norma_nr_doc_autoriz_ok;
    String _norma_data_doc_autoriz;
    Date _norma_data_doc_autoriz_f;
    boolean _norma_data_doc_autoriz_ok;
    String _norma_data_incep;
    Date _norma_data_incep_f;
    boolean _norma_data_incep_ok;
    String _norma_data_sf;
    Date _norma_data_sf_f;
    boolean _norma_data_sf_ok;
    String _norma_data_susp;
    Date _norma_data_susp_f;
    boolean _norma_data_susp_ok;
    String _norma_nr_zile_scutite;
    long _norma_nr_zile_scutite_f;
    boolean _norma_nr_zile_scutite_ok;
    String _real_norma_venit;
    long _real_norma_venit_f;
    boolean _real_norma_venit_ok;
    String _real_ajustare;
    long _real_ajustare_f;
    boolean _real_ajustare_ok;
    String _real_venit_net_anual;
    long _real_venit_net_anual_f;
    boolean _real_venit_net_anual_ok;
    String _real_venit_impozit;
    long _real_venit_impozit_f;
    boolean _real_venit_impozit_ok;
    String _real_impozit;
    long _real_impozit_f;
    boolean _real_impozit_ok;

    public Cap12(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._norma_categ_venit = this._validator.nextAttributeInList(this._params._norma_categ_venit, "norma_categ_venit", 0, 1, 1);
        this._norma_categ_venit_f = this._validator._integerValue;
        this._norma_categ_venit_ok = this._validator._attributeOK;
        this._norma_nr_camere = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "norma_nr_camere", 0, 1, 0);
        this._norma_nr_camere_f = this._validator._integerValue;
        this._norma_nr_camere_ok = this._validator._attributeOK;
        this._norma_forma_org = this._validator.nextAttributeInInterval(1L, 2L, "norma_forma_org", 0, 1, 0);
        this._norma_forma_org_f = this._validator._integerValue;
        this._norma_forma_org_ok = this._validator._attributeOK;
        this._norma_caen = this._validator.nextAttributeInList(this._params._listaCaen, "norma_caen", 4, 4, 0);
        this._norma_caen_ok = this._validator._attributeOK;
        this._norma_descriere_sediu_bun = this._validator.nextAttribute("norma_descriere_sediu_bun", 250, 4, 0);
        this._norma_descriere_sediu_bun_ok = this._validator._attributeOK;
        this._norma_nr_doc_autoriz = this._validator.nextAttribute("norma_nr_doc_autoriz", 15, 4, 0);
        this._norma_nr_doc_autoriz_ok = this._validator._attributeOK;
        this._norma_data_doc_autoriz = this._validator.nextAttribute("norma_data_doc_autoriz", 0, 3, 0);
        this._norma_data_doc_autoriz_f = this._validator._dateValue;
        this._norma_data_doc_autoriz_ok = this._validator._attributeOK;
        this._norma_data_incep = this._validator.nextAttribute("norma_data_incep", 0, 3, 1);
        this._norma_data_incep_f = this._validator._dateValue;
        this._norma_data_incep_ok = this._validator._attributeOK;
        this._norma_data_sf = this._validator.nextAttribute("norma_data_sf", 0, 3, 0);
        this._norma_data_sf_f = this._validator._dateValue;
        this._norma_data_sf_ok = this._validator._attributeOK;
        this._norma_data_susp = this._validator.nextAttribute("norma_data_susp", 0, 3, 0);
        this._norma_data_susp_f = this._validator._dateValue;
        this._norma_data_susp_ok = this._validator._attributeOK;
        this._norma_nr_zile_scutite = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "norma_nr_zile_scutite", 0, 1, 0);
        this._norma_nr_zile_scutite_f = this._validator._integerValue;
        this._norma_nr_zile_scutite_ok = this._validator._attributeOK;
        this._real_norma_venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "real_norma_venit", 0, 1, 1);
        this._real_norma_venit_f = this._validator._integerValue;
        this._real_norma_venit_ok = this._validator._attributeOK;
        this._real_ajustare = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "real_ajustare", 0, 1, 1);
        this._real_ajustare_f = this._validator._integerValue;
        this._real_ajustare_ok = this._validator._attributeOK;
        this._real_venit_net_anual = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "real_venit_net_anual", 0, 1, 1);
        this._real_venit_net_anual_f = this._validator._integerValue;
        this._real_venit_net_anual_ok = this._validator._attributeOK;
        this._real_venit_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "real_venit_impozit", 0, 1, 1);
        this._real_venit_impozit_f = this._validator._integerValue;
        this._real_venit_impozit_ok = this._validator._attributeOK;
        this._real_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "real_impozit", 0, 1, 1);
        this._real_impozit_f = this._validator._integerValue;
        this._real_impozit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        String string = null;
        d212.nr_cap12 = 1L;
        if (d212._d_rec_f == 1L && d212._rectif1_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 1 ( rectif1)", new Object[0]));
        }
        d212.real_impozit += this._real_impozit_f;
        if (this._norma_categ_venit_f == 1016L && this._norma_nr_camere == null && this._norma_nr_camere != null && (this._norma_nr_camere_f < 1L || this._norma_nr_camere_f > 5L)) {
            this._validator.addError(1, "R99.1", "", this._validator.fillParams("Pt norma_nr_camere este obligatoriu pt norma_categ_venit = 1016", new Object[0]));
        }
        if ((this._norma_categ_venit_f == 1016L || this._norma_categ_venit_f == 1004L) && this._norma_forma_org == null) {
            this._validator.addError(1, "R100", "", this._validator.fillParams("Pt categ_venit 1016 si 1004, norma_forma_org trebuie sa existe", new Object[0]));
        }
        if (this._norma_categ_venit_f == 1016L && this._norma_caen == null) {
            this._validator.addError(1, "R101", "", this._validator.fillParams("Pt categ_venit 1016, norma_caen trebuie sa existe", new Object[0]));
        }
        if ((this._norma_categ_venit_f == 1016L || this._norma_categ_venit_f == 1004L) && this._norma_descriere_sediu_bun == null) {
            this._validator.addError(1, "R102", "", this._validator.fillParams("Pt categ_venit 1016 si 1004, norma_descriere_sediu_bun trebuie sa existe", new Object[0]));
        }
        if (this._norma_categ_venit_f == 1016L && this._norma_nr_doc_autoriz == null) {
            this._validator.addError(1, "R103", "", this._validator.fillParams("Pt categ_venit = 1016, norma_nr_doc_autoriz trebuie sa existe", new Object[0]));
        }
        if (this._norma_nr_doc_autoriz != null && this._norma_data_doc_autoriz == null || this._norma_nr_doc_autoriz == null && this._norma_data_doc_autoriz != null) {
            this._validator.addError(1, "R104", "", this._validator.fillParams("daca norma_nr_doc_autoriz <>null atunci si norma_data_doc_autoriz <>null", new Object[0]));
        }
        if (this._norma_data_incep != null && this._norma_data_sf != null && this._norma_data_sf_f.before(this._norma_data_incep_f)) {
            this._validator.addError(1, "R105", "", this._validator.fillParams("Data sfarsit nu poate fi anterioara datei de inceput", new Object[0]));
        }
        if (this._norma_data_incep != null && this._norma_data_sf != null && this._norma_data_susp != null && (this._norma_data_sf_f.before(this._norma_data_susp_f) || this._norma_data_susp_f.before(this._norma_data_incep_f))) {
            this._validator.addError(1, "R107", "", this._validator.fillParams("Data sfarsit nu poate fi anterioare datei suspendare si data suspendare nu poate fi anterioara datei de inceput", new Object[0]));
        }
        if (this._norma_categ_venit_f != 1016L && this._norma_nr_zile_scutite != null) {
            this._validator.addError(1, "R108", "", this._validator.fillParams("Pt categ_venit diferit de 1016, norma_nr_zile_scutite nu trebuie sa existe", new Object[0]));
        }
        if (this._norma_categ_venit_f == 1006L && this._real_ajustare_f > this._real_norma_venit_f) {
            this._validator.addError(1, "R110", "", this._validator.fillParams("Pt categ_venit = 1006, real_ajustare <= real_norma_venit", new Object[0]));
        }
        if (this._norma_categ_venit_f == 1006L && this._real_venit_net_anual_f != this._real_ajustare_f) {
            this._validator.addError(1, "R111", "", this._validator.fillParams("Pt categ_venit = 1006, real_venit_net_anual  = real_ajustare", new Object[0]));
        }
        if (this._real_impozit_f != Math.round(0.1 * (double)this._real_venit_impozit_f)) {
            this._validator.addError(1, "R113", "", this._validator.fillParams("real_impozit = math.round (real_venit_impozit * 10 / 100) rotunjire la numar intreg", new Object[0]));
        }
        if (this._norma_categ_venit != null && this._norma_nr_doc_autoriz != null && this._norma_data_doc_autoriz != null) {
            string = this._norma_categ_venit + "|" + this._norma_nr_doc_autoriz + "|" + this._norma_data_doc_autoriz;
            if (d212._listaPerechiNormaCategVenit.contains(string)) {
                this._validator.addError(1, "RUnicitate", "ERR \u2013 nu puteti avea mai multe aparitii pentru perechea (norma_categ_venit+norma_nr_doc_autoriz+norma_data_doc_autoriz)", this._validator.fillParams("tripletul (norma_categ_venit (@0@), norma_nr_doc_autoriz (@1@), norma_data_doc_autoriz (@2@)) nu este unic", new Object[]{Long.toString(this._norma_categ_venit_f), this._norma_nr_doc_autoriz, this._norma_data_doc_autoriz}));
            } else {
                d212._listaPerechiNormaCategVenit.add(string);
            }
        }
    }

    public void initialization() {
        this._norma_categ_venit = null;
        this._norma_categ_venit_f = 0L;
        this._norma_categ_venit_ok = false;
        this._norma_nr_camere = null;
        this._norma_nr_camere_f = 0L;
        this._norma_nr_camere_ok = false;
        this._norma_forma_org = null;
        this._norma_forma_org_f = 0L;
        this._norma_forma_org_ok = false;
        this._norma_caen = null;
        this._norma_caen_ok = false;
        this._norma_descriere_sediu_bun = null;
        this._norma_descriere_sediu_bun_ok = false;
        this._norma_nr_doc_autoriz = null;
        this._norma_nr_doc_autoriz_ok = false;
        this._norma_data_doc_autoriz = null;
        this._norma_data_doc_autoriz_f = null;
        this._norma_data_doc_autoriz_ok = false;
        this._norma_data_incep = null;
        this._norma_data_incep_f = null;
        this._norma_data_incep_ok = false;
        this._norma_data_sf = null;
        this._norma_data_sf_f = null;
        this._norma_data_sf_ok = false;
        this._norma_data_susp = null;
        this._norma_data_susp_f = null;
        this._norma_data_susp_ok = false;
        this._norma_nr_zile_scutite = null;
        this._norma_nr_zile_scutite_f = 0L;
        this._norma_nr_zile_scutite_ok = false;
        this._real_norma_venit = null;
        this._real_norma_venit_f = 0L;
        this._real_norma_venit_ok = false;
        this._real_ajustare = null;
        this._real_ajustare_f = 0L;
        this._real_ajustare_ok = false;
        this._real_venit_net_anual = null;
        this._real_venit_net_anual_f = 0L;
        this._real_venit_net_anual_ok = false;
        this._real_venit_impozit = null;
        this._real_venit_impozit_f = 0L;
        this._real_venit_impozit_ok = false;
        this._real_impozit = null;
        this._real_impozit_f = 0L;
        this._real_impozit_ok = false;
    }
}

