/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v3;

import d212validator.v3.D212;
import d212validator.v3.DataObjectRoot;
import d212validator.v3.ValidatorImpl;
import dec.DECConst;

public class Cap15
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP15 = 0;
    String _bifa_destinatie;
    long _bifa_destinatie_f;
    boolean _bifa_destinatie_ok;
    String _den_entitate;
    boolean _den_entitate_ok;
    String _cif_entitate;
    long _cif_entitate_f;
    boolean _cif_entitate_ok;
    String _cont_entitate;
    boolean _cont_entitate_ok;
    String _contract_bursa;
    boolean _contract_bursa_ok;
    String _doc_plata_bursa;
    boolean _doc_plata_bursa_ok;
    String _suma;
    long _suma_f;
    boolean _suma_ok;

    public Cap15(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._bifa_destinatie = this._validator.nextAttributeInInterval(2L, 3L, "bifa_destinatie", 0, 1, 1);
        this._bifa_destinatie_f = this._validator._integerValue;
        this._bifa_destinatie_ok = this._validator._attributeOK;
        this._den_entitate = this._validator.nextAttribute("den_entitate", 250, 4, 0);
        this._den_entitate_ok = this._validator._attributeOK;
        this._cif_entitate = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_10, "cif_entitate", 0, 1, 0);
        this._cif_entitate_f = this._validator._integerValue;
        this._cif_entitate_ok = this._validator._attributeOK;
        this._cont_entitate = this._validator.nextAttribute("cont_entitate", 24, 4, 0);
        this._cont_entitate_ok = this._validator._attributeOK;
        this._contract_bursa = this._validator.nextAttribute("contract_bursa", 150, 4, 0);
        this._contract_bursa_ok = this._validator._attributeOK;
        this._doc_plata_bursa = this._validator.nextAttribute("doc_plata_bursa", 150, 4, 0);
        this._doc_plata_bursa_ok = this._validator._attributeOK;
        this._suma = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "suma", 0, 1, 0);
        this._suma_f = this._validator._integerValue;
        this._suma_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        d212.nr_cap15 = 1L;
        if (d212._d_rec_f == 1L && d212._rectif1_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 1 ( rectif1)", new Object[0]));
        }
        if (this._bifa_destinatie_f == 2L && this._cif_entitate == null) {
            this._validator.addError(1, "R133", "", this._validator.fillParams("Daca bifa_detinatie = 2, atunci cif_entitate trebuie sa existe", new Object[0]));
        }
        if (this._bifa_destinatie_f == 2L && this._cont_entitate == null) {
            this._validator.addError(1, "R134", "", this._validator.fillParams("Daca bifa_detinatie = 2, atunci cont_entitate trebuie sa existe", new Object[0]));
        }
        if (this._bifa_destinatie_f == 3L && this._contract_bursa == null) {
            this._validator.addError(1, "R135", "", this._validator.fillParams("Daca bifa_detinatie = 3, atunci cif_entitate trebuie sa existe", new Object[0]));
        }
        if (this._contract_bursa != null && !this._contract_bursa.matches(".{0,139}\\/([0-2][0-9]||3[0-1])\\.(0[0-9]||1[0-2])\\.[1-9][0-9][0-9][0-9]")) {
            this._validator.addError(1, "R-format contract_bursa", "", this._validator.fillParams("Formatul pentru campul contract_bursa nu este corect! Numarul contractului trebuie separat prin semnul '/' de data contract. Data contract trebuie sa aibe forma zz.ll.aaaa. Exemplu: 11111/05.12.2019", new Object[0]));
        }
        if (this._bifa_destinatie_f == 3L && this._doc_plata_bursa == null) {
            this._validator.addError(1, "R136", "", this._validator.fillParams("Daca bifa_detinatie = 3, atunci doc_plata_bursa trebuie sa existe", new Object[0]));
        }
        if (this._doc_plata_bursa != null && !this._doc_plata_bursa.matches(".{0,139}\\/([0-2][0-9]||3[0-1])\\.(0[0-9]||1[0-2])\\.[1-9][0-9][0-9][0-9]")) {
            this._validator.addError(1, "R-format doc_plata_bursa", "", this._validator.fillParams("Formatul pentru campul doc_plata_bursa nu este corect! Numarul documentului de plata trebuie separat prin semnul '/' de data contract. Data contract trebuie sa aibe forma zz.ll.aaaa. Exemplu: 11111/05.12.2019", new Object[0]));
        }
        if (this._bifa_destinatie_f == 3L && this._suma == null) {
            this._validator.addError(1, "R137", "", this._validator.fillParams("Daca bifa_detinatie = 3, atunci suma trebuie sa existe", new Object[0]));
        }
    }

    public void initialization() {
        this._bifa_destinatie = null;
        this._bifa_destinatie_f = 0L;
        this._bifa_destinatie_ok = false;
        this._den_entitate = null;
        this._den_entitate_ok = false;
        this._cif_entitate = null;
        this._cif_entitate_f = 0L;
        this._cif_entitate_ok = false;
        this._cont_entitate = null;
        this._cont_entitate_ok = false;
        this._contract_bursa = null;
        this._contract_bursa_ok = false;
        this._doc_plata_bursa = null;
        this._doc_plata_bursa_ok = false;
        this._suma = null;
        this._suma_f = 0L;
        this._suma_ok = false;
    }
}

