/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v3;

import d212validator.v3.D212;
import d212validator.v3.DataObjectRoot;
import d212validator.v3.ValidatorImpl;
import dec.DECConst;
import java.util.Date;

public class Cap22
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP22 = 0;
    String _estn_categ_venit;
    long _estn_categ_venit_f;
    boolean _estn_categ_venit_ok;
    String _estn_nr_camere;
    long _estn_nr_camere_f;
    boolean _estn_nr_camere_ok;
    String _estn_forma_org;
    long _estn_forma_org_f;
    boolean _estn_forma_org_ok;
    String _estn_caen;
    boolean _estn_caen_ok;
    String _estn_descriere_sediu_bun;
    boolean _estn_descriere_sediu_bun_ok;
    String _estn_nr_doc_autoriz;
    boolean _estn_nr_doc_autoriz_ok;
    String _estn_data_doc_autoriz;
    Date _estn_data_doc_autoriz_f;
    boolean _estn_data_doc_autoriz_ok;
    String _estn_data_incep;
    Date _estn_data_incep_f;
    boolean _estn_data_incep_ok;
    String _estn_data_sf;
    Date _estn_data_sf_f;
    boolean _estn_data_sf_ok;
    String _estn_data_susp;
    Date _estn_data_susp_f;
    boolean _estn_data_susp_ok;
    String _estn_nr_zile_scutite;
    long _estn_nr_zile_scutite_f;
    boolean _estn_nr_zile_scutite_ok;
    String _estn_norma_venit;
    long _estn_norma_venit_f;
    boolean _estn_norma_venit_ok;
    String _estn_ajustare;
    long _estn_ajustare_f;
    boolean _estn_ajustare_ok;
    String _estn_venit_net_anual;
    long _estn_venit_net_anual_f;
    boolean _estn_venit_net_anual_ok;
    String _estn_venit_impozit;
    long _estn_venit_impozit_f;
    boolean _estn_venit_impozit_ok;
    String _estn_impozit;
    long _estn_impozit_f;
    boolean _estn_impozit_ok;

    public Cap22(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._estn_categ_venit = this._validator.nextAttributeInList(this._params._estn_categ_venit, "estn_categ_venit", 0, 1, 1);
        this._estn_categ_venit_f = this._validator._integerValue;
        this._estn_categ_venit_ok = this._validator._attributeOK;
        this._estn_nr_camere = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "estn_nr_camere", 0, 1, 0);
        this._estn_nr_camere_f = this._validator._integerValue;
        this._estn_nr_camere_ok = this._validator._attributeOK;
        this._estn_forma_org = this._validator.nextAttributeInInterval(1L, 2L, "estn_forma_org", 0, 1, 0);
        this._estn_forma_org_f = this._validator._integerValue;
        this._estn_forma_org_ok = this._validator._attributeOK;
        this._estn_caen = this._validator.nextAttributeInList(this._params._listaCaen, "estn_caen", 4, 4, 0);
        this._estn_caen_ok = this._validator._attributeOK;
        this._estn_descriere_sediu_bun = this._validator.nextAttribute("estn_descriere_sediu_bun", 250, 4, 1);
        this._estn_descriere_sediu_bun_ok = this._validator._attributeOK;
        this._estn_nr_doc_autoriz = this._validator.nextAttribute("estn_nr_doc_autoriz", 15, 4, 0);
        this._estn_nr_doc_autoriz_ok = this._validator._attributeOK;
        this._estn_data_doc_autoriz = this._validator.nextAttribute("estn_data_doc_autoriz", 0, 3, 0);
        this._estn_data_doc_autoriz_f = this._validator._dateValue;
        this._estn_data_doc_autoriz_ok = this._validator._attributeOK;
        this._estn_data_incep = this._validator.nextAttribute("estn_data_incep", 0, 3, 0);
        this._estn_data_incep_f = this._validator._dateValue;
        this._estn_data_incep_ok = this._validator._attributeOK;
        this._estn_data_sf = this._validator.nextAttribute("estn_data_sf", 0, 3, 0);
        this._estn_data_sf_f = this._validator._dateValue;
        this._estn_data_sf_ok = this._validator._attributeOK;
        this._estn_data_susp = this._validator.nextAttribute("estn_data_susp", 0, 3, 0);
        this._estn_data_susp_f = this._validator._dateValue;
        this._estn_data_susp_ok = this._validator._attributeOK;
        this._estn_nr_zile_scutite = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_3, "estn_nr_zile_scutite", 0, 1, 0);
        this._estn_nr_zile_scutite_f = this._validator._integerValue;
        this._estn_nr_zile_scutite_ok = this._validator._attributeOK;
        this._estn_norma_venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_norma_venit", 0, 1, 1);
        this._estn_norma_venit_f = this._validator._integerValue;
        this._estn_norma_venit_ok = this._validator._attributeOK;
        this._estn_ajustare = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_ajustare", 0, 1, 1);
        this._estn_ajustare_f = this._validator._integerValue;
        this._estn_ajustare_ok = this._validator._attributeOK;
        this._estn_venit_net_anual = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_venit_net_anual", 0, 1, 1);
        this._estn_venit_net_anual_f = this._validator._integerValue;
        this._estn_venit_net_anual_ok = this._validator._attributeOK;
        this._estn_venit_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_venit_impozit", 0, 1, 1);
        this._estn_venit_impozit_f = this._validator._integerValue;
        this._estn_venit_impozit_ok = this._validator._attributeOK;
        this._estn_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "estn_impozit", 0, 1, 0);
        this._estn_impozit_f = this._validator._integerValue;
        this._estn_impozit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        D212 d212 = (D212)this._parent;
        String string = null;
        d212.nr_cap22 = 1L;
        if (d212._d_rec_f == 1L && d212._rectif2_f == 0L) {
            this._validator.addError(1, "Rectif", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata bifa de rectificativa a capitolului 2 ( rectif2)", new Object[0]));
        }
        d212.estn_impozit += this._estn_impozit_f;
        if (this._estn_categ_venit_f == 1006L && this._estn_nr_camere == null) {
            this._validator.addError(1, "R157", "", this._validator.fillParams("Daca estn_categ_venit = 1006, atunci estn_nr_camere trebuie sa existe", new Object[0]));
        }
        if (this._estn_nr_camere != null && (this._estn_nr_camere_f < 1L || this._estn_nr_camere_f > 5L)) {
            this._validator.addError(1, "R157.1", "", this._validator.fillParams("Daca estn_nr_camere <> nul, atunci estn_nr_camere trebuie sa fie intre 1 si 5", new Object[0]));
        }
        if ((this._estn_categ_venit_f == 1016L || this._estn_categ_venit_f == 1004L) && this._estn_forma_org == null) {
            this._validator.addError(1, "R158", "", this._validator.fillParams("Daca estn_categ_venit = 1016 sau 1004, atunci estn_forma_org trebuie sa existe", new Object[0]));
        }
        if (this._estn_categ_venit_f == 1016L && this._estn_caen == null) {
            this._validator.addError(1, "R159", "", this._validator.fillParams("Daca estn_categ_venit = 1016, atunci estn_caen trebuie sa existe", new Object[0]));
        }
        if (this._estn_data_doc_autoriz != null && this._estn_nr_doc_autoriz == null) {
            this._validator.addError(1, "R161", "", this._validator.fillParams("Daca estn_data_doc_autoriz <> null, atunci estn_nr_doc_autoriz <> null", new Object[0]));
        }
        if (this._estn_nr_doc_autoriz != null && this._estn_data_doc_autoriz == null) {
            this._validator.addError(1, "R162", "", this._validator.fillParams("Daca estn_nr_doc_autoriz <> null, atunci estn_data_doc_autoriz <> null", new Object[0]));
        }
        if (this._estn_data_incep != null && this._estn_data_sf != null && this._estn_data_sf_f.before(this._estn_data_incep_f)) {
            this._validator.addError(1, "R163", "", this._validator.fillParams("Data sfarsit nu poate fi anterioara datei de inceput", new Object[0]));
        }
        if (this._estn_categ_venit_f != 1016L && this._estn_nr_zile_scutite != null) {
            this._validator.addError(1, "R166", "", this._validator.fillParams("Daca estn_categ_venit =1016, atunci estn_nr_zile_scutite <> null", new Object[0]));
        }
        if (this._estn_categ_venit_f == 1006L && this._estn_ajustare_f > this._estn_norma_venit_f) {
            this._validator.addError(1, "R168", "", this._validator.fillParams("Daca estn_categ_venit =1006, atunci estn_ajustare <= estn_norma_venit", new Object[0]));
        }
        if (this._estn_categ_venit_f == 1006L && this._estn_venit_net_anual_f != this._estn_ajustare_f) {
            this._validator.addError(1, "R169", "", this._validator.fillParams("Daca estn_categ_venit =1006, atunci estn_venit_net_anual = estn_ajustare", new Object[0]));
        }
        if (this._estn_categ_venit_f != 1006L && this._estn_venit_net_anual_f > this._estn_ajustare_f) {
            this._validator.addError(1, "R169.1", "", this._validator.fillParams("Daca estn_categ_venit diferit de 1006, atunci estn_venit_net_anual <= estn_ajustare", new Object[0]));
        }
        if ((this._estn_categ_venit_f == 1004L || this._estn_categ_venit_f == 1006L) && this._estn_venit_impozit_f != this._estn_venit_net_anual_f) {
            this._validator.addError(1, "R170", "", this._validator.fillParams("Daca estn_categ_venit 1004,1006, atunci estn_venit_impozit = estn_venit_net_anual", new Object[0]));
        }
        if ((this._estn_categ_venit_f != 1004L || this._estn_categ_venit_f != 1006L) && this._estn_venit_impozit_f > this._estn_venit_net_anual_f) {
            this._validator.addError(1, "R170.1", "", this._validator.fillParams("Daca estn_categ_venit diferti de 1004,1006, atunci estn_venit_impozit > estn_venit_net_anual", new Object[0]));
        }
        if (this._estn_impozit_f != Math.round(0.1 * (double)this._estn_venit_impozit_f)) {
            this._validator.addError(1, "R171", "", this._validator.fillParams("estn_impozit = 10/100 * estn_venit_impozit", new Object[0]));
        }
        if (this._estn_categ_venit != null && this._estn_nr_doc_autoriz != null && this._estn_data_doc_autoriz != null) {
            string = this._estn_categ_venit + "|" + this._estn_nr_doc_autoriz + "|" + this._estn_data_doc_autoriz;
            if (d212._listaPerechiEstnCategVenit.contains(string)) {
                this._validator.addError(1, "RUnicitate", "ERR \u2013 nu puteti avea mai multe aparitii pentru perechea (estn_categ_venit+estn_nr_doc_autoriz+estn_data_doc_autoriz)", this._validator.fillParams("tripletul (estn_categ_venit (@0@), estn_nr_doc_autoriz (@1@), estn_data_doc_autoriz (@2@)) nu este unic", new Object[]{Long.toString(this._estn_categ_venit_f), this._estn_nr_doc_autoriz, this._estn_data_doc_autoriz}));
            } else {
                d212._listaPerechiEstnCategVenit.add(string);
            }
        }
    }

    public void initialization() {
        this._estn_categ_venit = null;
        this._estn_categ_venit_f = 0L;
        this._estn_categ_venit_ok = false;
        this._estn_nr_camere = null;
        this._estn_nr_camere_f = 0L;
        this._estn_nr_camere_ok = false;
        this._estn_forma_org = null;
        this._estn_forma_org_f = 0L;
        this._estn_forma_org_ok = false;
        this._estn_caen = null;
        this._estn_caen_ok = false;
        this._estn_descriere_sediu_bun = null;
        this._estn_descriere_sediu_bun_ok = false;
        this._estn_nr_doc_autoriz = null;
        this._estn_nr_doc_autoriz_ok = false;
        this._estn_data_doc_autoriz = null;
        this._estn_data_doc_autoriz_f = null;
        this._estn_data_doc_autoriz_ok = false;
        this._estn_data_incep = null;
        this._estn_data_incep_f = null;
        this._estn_data_incep_ok = false;
        this._estn_data_sf = null;
        this._estn_data_sf_f = null;
        this._estn_data_sf_ok = false;
        this._estn_data_susp = null;
        this._estn_data_susp_f = null;
        this._estn_data_susp_ok = false;
        this._estn_nr_zile_scutite = null;
        this._estn_nr_zile_scutite_f = 0L;
        this._estn_nr_zile_scutite_ok = false;
        this._estn_norma_venit = null;
        this._estn_norma_venit_f = 0L;
        this._estn_norma_venit_ok = false;
        this._estn_ajustare = null;
        this._estn_ajustare_f = 0L;
        this._estn_ajustare_ok = false;
        this._estn_venit_net_anual = null;
        this._estn_venit_net_anual_f = 0L;
        this._estn_venit_net_anual_ok = false;
        this._estn_venit_impozit = null;
        this._estn_venit_impozit_f = 0L;
        this._estn_venit_impozit_ok = false;
        this._estn_impozit = null;
        this._estn_impozit_f = 0L;
        this._estn_impozit_ok = false;
    }
}

