/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v4;

import d212validator.v4.DataObjectRoot;
import d212validator.v4.ValidatorImpl;
import dec.DECConst;

public class Cap16
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP16 = 0;
    String _indemnizatie16_luna;
    long _indemnizatie16_luna_f;
    boolean _indemnizatie16_luna_ok;
    String _indemnizatie16_bruta;
    long _indemnizatie16_bruta_f;
    boolean _indemnizatie16_bruta_ok;
    String _indemnizatie16_cas;
    long _indemnizatie16_cas_f;
    boolean _indemnizatie16_cas_ok;
    String _indemnizatie16_casp;
    long _indemnizatie16_casp_f;
    boolean _indemnizatie16_casp_ok;
    String _indemnizatie16_cass;
    long _indemnizatie16_cass_f;
    boolean _indemnizatie16_cass_ok;
    String _indemnizatie16_venit;
    long _indemnizatie16_venit_f;
    boolean _indemnizatie16_venit_ok;
    String _indemnizatie16_impozit;
    long _indemnizatie16_impozit_f;
    boolean _indemnizatie16_impozit_ok;

    public Cap16(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._indemnizatie16_luna = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_2, "indemnizatie16_luna", 0, 1, 1);
        this._indemnizatie16_luna_f = this._validator._integerValue;
        this._indemnizatie16_luna_ok = this._validator._attributeOK;
        this._indemnizatie16_bruta = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie16_bruta", 0, 1, 1);
        this._indemnizatie16_bruta_f = this._validator._integerValue;
        this._indemnizatie16_bruta_ok = this._validator._attributeOK;
        this._indemnizatie16_cas = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie16_cas", 0, 1, 0);
        this._indemnizatie16_cas_f = this._validator._integerValue;
        this._indemnizatie16_cas_ok = this._validator._attributeOK;
        this._indemnizatie16_casp = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie16_casp", 0, 1, 0);
        this._indemnizatie16_casp_f = this._validator._integerValue;
        this._indemnizatie16_casp_ok = this._validator._attributeOK;
        this._indemnizatie16_cass = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie16_cass", 0, 1, 1);
        this._indemnizatie16_cass_f = this._validator._integerValue;
        this._indemnizatie16_cass_ok = this._validator._attributeOK;
        this._indemnizatie16_venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie16_venit", 0, 1, 1);
        this._indemnizatie16_venit_f = this._validator._integerValue;
        this._indemnizatie16_venit_ok = this._validator._attributeOK;
        this._indemnizatie16_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie16_impozit", 0, 1, 1);
        this._indemnizatie16_impozit_f = this._validator._integerValue;
        this._indemnizatie16_impozit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        if (this._indemnizatie16_luna_f < 3L || this._indemnizatie16_luna_f > 12L) {
            this._validator.addError(1, "R142", "", this._validator.fillParams("Cap16. Luna trebuie sa fie intre martie si decembrie", new Object[0]));
        }
        if (this._indemnizatie16_bruta_f <= 0L) {
            this._validator.addError(1, "R143", "", this._validator.fillParams("Cap16. Indemnizatia bruta trebuie sa fie mai mare decat 0.", new Object[0]));
        }
        long l = Math.round((double)this._indemnizatie16_bruta_f * 0.25);
        if (this._indemnizatie16_cas != null && this._indemnizatie16_cas_f != l) {
            this._validator.addError(1, "R144", "", this._validator.fillParams("Cap16. Indemnizatia cas (@0@) trebuie sa fie 25% din indemnizatia bruta.(@1@)", new Object[]{Long.toString(this._indemnizatie16_cas_f), Long.toString(l)}));
        }
        l = Math.round((double)this._indemnizatie16_bruta_f * 0.25);
        if (this._indemnizatie16_casp != null && this._indemnizatie16_casp_f != l) {
            this._validator.addError(1, "R144.a", "", this._validator.fillParams("Cap16. Indemnizatia casp (@0@) trebuie sa fie 25% din indemnizatia bruta.(@1@)", new Object[]{Long.toString(this._indemnizatie16_casp_f), Long.toString(l)}));
        }
        if (this._indemnizatie16_casp != null && this._indemnizatie16_cas != null || this._indemnizatie16_casp == null && this._indemnizatie16_cas == null) {
            this._validator.addError(1, "R144+a", "", this._validator.fillParams("Cap16. indemnizatie16_cas si indemnizatie16_casp nu pot fi null si nu pot fi completate in acelasi timp", new Object[0]));
        }
        if (this._indemnizatie16_cass_f != (l = Math.round((double)this._indemnizatie16_bruta_f * 0.1))) {
            this._validator.addError(1, "R145", "", this._validator.fillParams("Cap16. Indemnizatia cass (@0@)trebuie sa fie 10% din indemnizatia bruta.(@1@)", new Object[]{Long.toString(this._indemnizatie16_cass_f), Long.toString(l)}));
        }
        if (this._indemnizatie16_venit_f != (l = this._indemnizatie16_bruta_f - this._indemnizatie16_cas_f - this._indemnizatie16_casp_f - this._indemnizatie16_cass_f)) {
            this._validator.addError(1, "R146", "", this._validator.fillParams("Cap16. indemnizatie16_venit (@0@) difera de indemnizatie16_bruta \u2013 indemnizatie16_cas - indemnizatie16_casp - indemnizatie16_cass (@1@) .", new Object[]{Long.toString(this._indemnizatie16_venit_f), Long.toString(l)}));
        }
        if (this._indemnizatie16_impozit_f != (l = Math.round((double)this._indemnizatie16_venit_f * 0.1))) {
            this._validator.addError(1, "R147", "", this._validator.fillParams("Cap16. Impozitul(@0@) trebuie sa fie 10% din venit.(@1@)", new Object[]{Long.toString(this._indemnizatie16_impozit_f), Long.toString(l)}));
        }
    }

    public void initialization() {
        this._indemnizatie16_luna = null;
        this._indemnizatie16_luna_f = 0L;
        this._indemnizatie16_luna_ok = false;
        this._indemnizatie16_bruta = null;
        this._indemnizatie16_bruta_f = 0L;
        this._indemnizatie16_bruta_ok = false;
        this._indemnizatie16_cas = null;
        this._indemnizatie16_cas_f = 0L;
        this._indemnizatie16_cas_ok = false;
        this._indemnizatie16_casp = null;
        this._indemnizatie16_casp_f = 0L;
        this._indemnizatie16_casp_ok = false;
        this._indemnizatie16_cass = null;
        this._indemnizatie16_cass_f = 0L;
        this._indemnizatie16_cass_ok = false;
        this._indemnizatie16_venit = null;
        this._indemnizatie16_venit_f = 0L;
        this._indemnizatie16_venit_ok = false;
        this._indemnizatie16_impozit = null;
        this._indemnizatie16_impozit_f = 0L;
        this._indemnizatie16_impozit_ok = false;
    }
}

