/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v4;

import d212validator.v4.DataObjectRoot;
import d212validator.v4.ValidatorImpl;
import dec.DECConst;

public class Cap17
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_CAP17 = 0;
    String _indemnizatie17_luna;
    long _indemnizatie17_luna_f;
    boolean _indemnizatie17_luna_ok;
    String _indemnizatie17_bruta;
    long _indemnizatie17_bruta_f;
    boolean _indemnizatie17_bruta_ok;
    String _indemnizatie17_cas;
    long _indemnizatie17_cas_f;
    boolean _indemnizatie17_cas_ok;
    String _indemnizatie17_casp;
    long _indemnizatie17_casp_f;
    boolean _indemnizatie17_casp_ok;
    String _indemnizatie17_cass;
    long _indemnizatie17_cass_f;
    boolean _indemnizatie17_cass_ok;
    String _indemnizatie17_venit;
    long _indemnizatie17_venit_f;
    boolean _indemnizatie17_venit_ok;
    String _indemnizatie17_impozit;
    long _indemnizatie17_impozit_f;
    boolean _indemnizatie17_impozit_ok;

    public Cap17(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._indemnizatie17_luna = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_2, "indemnizatie17_luna", 0, 1, 1);
        this._indemnizatie17_luna_f = this._validator._integerValue;
        this._indemnizatie17_luna_ok = this._validator._attributeOK;
        this._indemnizatie17_bruta = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie17_bruta", 0, 1, 1);
        this._indemnizatie17_bruta_f = this._validator._integerValue;
        this._indemnizatie17_bruta_ok = this._validator._attributeOK;
        this._indemnizatie17_cas = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie17_cas", 0, 1, 0);
        this._indemnizatie17_cas_f = this._validator._integerValue;
        this._indemnizatie17_cas_ok = this._validator._attributeOK;
        this._indemnizatie17_casp = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie17_casp", 0, 1, 0);
        this._indemnizatie17_casp_f = this._validator._integerValue;
        this._indemnizatie17_casp_ok = this._validator._attributeOK;
        this._indemnizatie17_cass = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie17_cass", 0, 1, 1);
        this._indemnizatie17_cass_f = this._validator._integerValue;
        this._indemnizatie17_cass_ok = this._validator._attributeOK;
        this._indemnizatie17_venit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie17_venit", 0, 1, 1);
        this._indemnizatie17_venit_f = this._validator._integerValue;
        this._indemnizatie17_venit_ok = this._validator._attributeOK;
        this._indemnizatie17_impozit = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_15, "indemnizatie17_impozit", 0, 1, 1);
        this._indemnizatie17_impozit_f = this._validator._integerValue;
        this._indemnizatie17_impozit_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        if (this._indemnizatie17_luna_f < 7L || this._indemnizatie17_luna_f > 12L) {
            this._validator.addError(1, "R150", "", this._validator.fillParams("Cap17. Luna trebuie sa fie intre iulie si decembrie", new Object[0]));
        }
        if (this._indemnizatie17_bruta_f <= 0L) {
            this._validator.addError(1, "R151", "", this._validator.fillParams("Cap17. Indemnizatia bruta trebuie sa fie mai mare decat 0.", new Object[0]));
        }
        long l = Math.round((double)this._indemnizatie17_bruta_f * 0.25);
        if (this._indemnizatie17_cas != null && this._indemnizatie17_cas_f != l) {
            this._validator.addError(1, "R152", "", this._validator.fillParams("Cap17. Indemnizatia cas (@0@) trebuie sa fie 25% din indemnizatia bruta.(@1@)", new Object[]{Long.toString(this._indemnizatie17_cas_f), Long.toString(l)}));
        }
        if (this._indemnizatie17_casp != null && this._indemnizatie17_cas != null || this._indemnizatie17_casp == null && this._indemnizatie17_cas == null) {
            this._validator.addError(1, "R152.a", "", this._validator.fillParams("Cap17. indemnizatie17_cas si indemnizatie17_casp nu pot fi null si nu pot fi completate in acelasi timp", new Object[0]));
        }
        if (this._indemnizatie17_cass_f != (l = Math.round((double)this._indemnizatie17_bruta_f * 0.1))) {
            this._validator.addError(1, "R153", "", this._validator.fillParams("Cap17. Indemnizatia cass (@0@)trebuie sa fie 10% din indemnizatia bruta.(@1@)", new Object[]{Long.toString(this._indemnizatie17_cass_f), Long.toString(l)}));
        }
        if (this._indemnizatie17_venit_f != (l = this._indemnizatie17_bruta_f - this._indemnizatie17_cas_f - this._indemnizatie17_casp_f - this._indemnizatie17_cass_f)) {
            this._validator.addError(1, "R154", "", this._validator.fillParams("Cap17. indemnizatie17_venit (@0@) difera de indemnizatie17_bruta \u2013 indemnizatie17_cas - indemnizatie17_casp - indemnizatie17_cass (@1@) .", new Object[]{Long.toString(this._indemnizatie17_venit_f), Long.toString(l)}));
        }
        if (this._indemnizatie17_impozit_f != (l = Math.round((double)this._indemnizatie17_venit_f * 0.1))) {
            this._validator.addError(1, "R155", "", this._validator.fillParams("Cap17. Impozitul(@0@) trebuie sa fie 10% din venit.(@1@)", new Object[]{Long.toString(this._indemnizatie17_impozit_f), Long.toString(l)}));
        }
    }

    public void initialization() {
        this._indemnizatie17_luna = null;
        this._indemnizatie17_luna_f = 0L;
        this._indemnizatie17_luna_ok = false;
        this._indemnizatie17_bruta = null;
        this._indemnizatie17_bruta_f = 0L;
        this._indemnizatie17_bruta_ok = false;
        this._indemnizatie17_cas = null;
        this._indemnizatie17_cas_f = 0L;
        this._indemnizatie17_cas_ok = false;
        this._indemnizatie17_casp = null;
        this._indemnizatie17_casp_f = 0L;
        this._indemnizatie17_casp_ok = false;
        this._indemnizatie17_cass = null;
        this._indemnizatie17_cass_f = 0L;
        this._indemnizatie17_cass_ok = false;
        this._indemnizatie17_venit = null;
        this._indemnizatie17_venit_f = 0L;
        this._indemnizatie17_venit_ok = false;
        this._indemnizatie17_impozit = null;
        this._indemnizatie17_impozit_f = 0L;
        this._indemnizatie17_impozit_ok = false;
    }
}

