/*
 * Decompiled with CFR 0.152.
 */
package d212validator.v4;

import d212validator.v4.Cap11;
import d212validator.v4.Cap12;
import d212validator.v4.Cap14;
import d212validator.v4.Cap16;
import d212validator.v4.Cap17;
import d212validator.v4.Cap23;
import d212validator.v4.DataObjectRoot;
import d212validator.v4.Oblig_estimat;
import d212validator.v4.Oblig_realizat;
import d212validator.v4.ValidatorImpl;
import dec.DECConst;
import java.util.Set;
import java.util.TreeSet;

public class D212
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_D212 = 0;
    Set<String> _listaUnicitateBifaDestinatie = new TreeSet<String>();
    Set<String> _listaPerechiCategVenit = new TreeSet<String>();
    Set<String> _listaPerechiNormaCategVenit = new TreeSet<String>();
    Set<String> _listaPerechiEstrCategVenit = new TreeSet<String>();
    Set<String> _listaPerechiEstnCategVenit = new TreeSet<String>();
    Set<String> _listaPerechiEstanUnicitate = new TreeSet<String>();
    String _luna_r;
    long _luna_r_f;
    boolean _luna_r_ok;
    String _an_r;
    long _an_r_f;
    boolean _an_r_ok;
    String _rectif1;
    long _rectif1_f;
    boolean _rectif1_ok;
    String _rectif2;
    long _rectif2_f;
    boolean _rectif2_ok;
    String _d_rec;
    long _d_rec_f;
    boolean _d_rec_ok;
    String _nume_c;
    boolean _nume_c_ok;
    String _adresa_c;
    boolean _adresa_c_ok;
    String _telefon_c;
    boolean _telefon_c_ok;
    String _fax_c;
    boolean _fax_c_ok;
    String _email_c;
    boolean _email_c_ok;
    String _cif;
    long _cif_f;
    boolean _cif_ok;
    String _totalPlata_A;
    long _totalPlata_A_f;
    boolean _totalPlata_A_ok;
    String _nerezident;
    long _nerezident_f;
    boolean _nerezident_ok;
    String _stat_rezidenta;
    boolean _stat_rezidenta_ok;
    String _cif_str;
    boolean _cif_str_ok;
    String _cont_bancar;
    boolean _cont_bancar_ok;
    String _den_i;
    boolean _den_i_ok;
    String _cif_i;
    long _cif_i_f;
    boolean _cif_i_ok;
    String _adresa_i;
    boolean _adresa_i_ok;
    String _telefon_i;
    boolean _telefon_i_ok;
    String _fax_i;
    boolean _fax_i_ok;
    String _email_i;
    boolean _email_i_ok;
    long val;
    long nr_cap11;
    long nr_cap12;
    long nr_cap14;
    long nr_cap16;
    long nr_cap17;
    long nr_cap15;
    long nr_cap21;
    long nr_cap22;
    long nr_cap23;
    long nr_d212_oblig_real;
    long nr_d212_oblig_est;
    long is1012;
    long venit_recalculat;
    long impozit11;
    long real_impozit;
    long joc_impozit;
    long str_dif_impozit_datorat;
    long estr_impozit_venit;
    long estn_impozit;
    String listaBifa;
    long indemnizatie16_impozit;
    long indemnizatie17_impozit;
    long indemnizatie16_cas;
    long indemnizatie17_cas;
    long indemnizatie16_cass;
    long indemnizatie17_cass;

    public D212(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._luna_r = this._validator.nextAttributeInInterval(12L, 12L, "luna_r", 0, 1, 1);
        this._luna_r_f = this._validator._integerValue;
        this._luna_r_ok = this._validator._attributeOK;
        this._an_r = this._validator.nextAttributeInInterval(2020L, 2100L, "an_r", 0, 1, 1);
        this._an_r_f = this._validator._integerValue;
        this._an_r_ok = this._validator._attributeOK;
        if (this._validator._extractValuesFlag == 1) {
            return;
        }
        this._rectif1 = this._validator.nextAttributeInInterval(0L, 1L, "rectif1", 0, 1, 1);
        this._rectif1_f = this._validator._integerValue;
        this._rectif1_ok = this._validator._attributeOK;
        this._rectif2 = this._validator.nextAttributeInInterval(0L, 1L, "rectif2", 0, 1, 1);
        this._rectif2_f = this._validator._integerValue;
        this._rectif2_ok = this._validator._attributeOK;
        this._d_rec = this._validator.nextAttributeInInterval(0L, 1L, "d_rec", 0, 1, 1);
        this._d_rec_f = this._validator._integerValue;
        this._d_rec_ok = this._validator._attributeOK;
        this._nume_c = this._validator.nextAttribute("nume_c", 250, 4, 1);
        this._nume_c_ok = this._validator._attributeOK;
        this._adresa_c = this._validator.nextAttribute("adresa_c", 200, 4, 1);
        this._adresa_c_ok = this._validator._attributeOK;
        this._telefon_c = this._validator.nextAttribute("telefon_c", 15, 4, 0);
        this._telefon_c_ok = this._validator._attributeOK;
        this._fax_c = this._validator.nextAttribute("fax_c", 15, 4, 0);
        this._fax_c_ok = this._validator._attributeOK;
        this._email_c = this._validator.nextAttributeEmail("email_c", 200, 0);
        this._email_c_ok = this._validator._attributeOK;
        this._cif = this._validator.nextAttributeAsNif("cif", 1);
        this._cif_f = this._validator._integerValue;
        this._cif_ok = this._validator._attributeOK;
        this._totalPlata_A = this._validator.nextAttributeInInterval(DECConst.M_LONG_16, DECConst.LONG_16, "totalPlata_A", 0, 1, 1);
        this._totalPlata_A_f = this._validator._integerValue;
        this._totalPlata_A_ok = this._validator._attributeOK;
        this._nerezident = this._validator.nextAttributeInInterval(0L, 1L, "nerezident", 0, 1, 1);
        this._nerezident_f = this._validator._integerValue;
        this._nerezident_ok = this._validator._attributeOK;
        this._stat_rezidenta = this._validator.nextAttributeInList(this._params._nomenclatorTari, "stat_rezidenta", 256, 4, 0);
        this._stat_rezidenta_ok = this._validator._attributeOK;
        this._cif_str = this._validator.nextAttribute("cif_str", 50, 4, 0);
        this._cif_str_ok = this._validator._attributeOK;
        this._cont_bancar = this._validator.nextAttribute("cont_bancar", 24, 4, 0);
        this._cont_bancar_ok = this._validator._attributeOK;
        this._den_i = this._validator.nextAttribute("den_i", 60, 4, 0);
        this._den_i_ok = this._validator._attributeOK;
        this._cif_i = this._validator.nextAttributeInInterval(DECConst.LONG_0, DECConst.LONG_13, "cif_i", 0, 1, 0);
        this._cif_i_f = this._validator._integerValue;
        this._cif_i_ok = this._validator._attributeOK;
        this._adresa_i = this._validator.nextAttribute("adresa_i", 200, 4, 0);
        this._adresa_i_ok = this._validator._attributeOK;
        this._telefon_i = this._validator.nextAttribute("telefon_i", 15, 4, 0);
        this._telefon_i_ok = this._validator._attributeOK;
        this._fax_i = this._validator.nextAttribute("fax_i", 15, 4, 0);
        this._fax_i_ok = this._validator._attributeOK;
        this._email_i = this._validator.nextAttribute("email_i", 200, 4, 0);
        this._email_i_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        int n2;
        int n3 = this._validator._cntCap11;
        Cap11 cap11 = this._validator._cap11[0];
        Cap12 cap12 = this._validator._cap12[0];
        Cap14 cap14 = this._validator._cap14[0];
        Object var6_6 = null;
        Cap16 cap16 = this._validator._cap16[0];
        Cap17 cap17 = this._validator._cap17[0];
        Object var9_9 = null;
        Object var10_10 = null;
        Cap23 cap23 = null;
        Oblig_realizat oblig_realizat = this._validator._oblig_realizat;
        Oblig_estimat oblig_estimat = this._validator._oblig_estimat;
        if (this._validator._existsOblig_realizat) {
            if (this._validator._cntCap11 > 0) {
                if (cap11._det_ven_net_f == 1L && (cap11._categ_venit_f == 1016L || cap11._categ_venit_f == 1003L) && oblig_realizat._real_venit_net != null && oblig_realizat._real_venit_net_f != this.venit_recalculat) {
                    this._validator.addError(1, "R36", "", this._validator.fillParams("Daca det_ven_net=1 si categ_venit 1016 sau 1003 si real_venit_net este completat, atunci real_venit_net (@0@) trebuie sa fie egal cu suma venit_recalculat (@1@)", new Object[]{Long.toString(oblig_realizat._real_venit_net_f), Long.toString(this.venit_recalculat)}));
                }
                if (cap11._det_ven_net_f == 1L && (cap11._categ_venit_f == 1016L || cap11._categ_venit_f == 1003L) && oblig_realizat._real_cas == null) {
                    this._validator.addError(1, "R37", "", this._validator.fillParams("Daca det_ven_net=1 si categ_venit 1016 sau 1003, atunci real_cas trebuie completat", new Object[0]));
                }
                this.val = oblig_realizat._real_venit_net_f - oblig_realizat._real_cas_f + oblig_realizat._real_amef_f;
                if (cap11._det_ven_net_f == 1L && (cap11._categ_venit_f == 1016L || cap11._categ_venit_f == 1003L) && oblig_realizat._real_venit_net_impozabil != null && this.val > 0L && oblig_realizat._real_venit_net_impozabil_f != this.val) {
                    this._validator.addError(1, "R38", "", this._validator.fillParams("Daca real_venit_net - real_cas>0 atunci real_venit_net_impozabil (@0@) =  real_venit_net - real_cas + real_amef (@1@)", new Object[]{Long.toString(oblig_realizat._real_venit_net_impozabil_f), Long.toString(this.val)}));
                }
                if (cap11._det_ven_net_f == 1L && (cap11._categ_venit_f == 1016L || cap11._categ_venit_f == 1003L) && cap11._nr_zile_scutite != null && oblig_realizat._real_venit_net_redus != null && oblig_realizat._real_venit_net_redus_f > oblig_realizat._real_venit_net_impozabil_f) {
                    this._validator.addError(1, "R39", "", this._validator.fillParams("real_venit_net_redus (@0@) trebuie sa fie <= real_venit_net_impozabil (@1@)", new Object[]{Long.toString(oblig_realizat._real_venit_net_redus_f), Long.toString(oblig_realizat._real_venit_net_impozabil_f)}));
                }
                if (cap11._det_ven_net_f == 1L && (cap11._categ_venit_f == 1016L || cap11._categ_venit_f == 1003L) && oblig_realizat._real_impozit_datorat != null) {
                    if (oblig_realizat._real_venit_net_redus != null) {
                        this.val = Math.round(0.1 * (double)oblig_realizat._real_venit_net_redus_f - (double)oblig_realizat._real_amef_f);
                        if (oblig_realizat._real_impozit_datorat_f != this.val) {
                            this._validator.addError(1, "R40", "", this._validator.fillParams("real_venit_net_redus (@0@) <>0 atunci real_impozit_datorat este real_venit_net_redus*10/100 - real_amef(@1@)", new Object[]{Long.toString(oblig_realizat._real_impozit_datorat_f), Long.toString(this.val)}));
                        }
                    } else {
                        this.val = Math.round(0.1 * (double)oblig_realizat._real_venit_net_impozabil_f - (double)oblig_realizat._real_amef_f);
                        if (oblig_realizat._real_impozit_datorat_f != this.val) {
                            this._validator.addError(1, "R40.1", "", this._validator.fillParams("real_venit_net_redus este null atunci real_impozit_datorat este real_venit_net_impozabil*10/100 - real_amef (@1@)", new Object[]{Long.toString(oblig_realizat._real_impozit_datorat_f), Long.toString(this.val)}));
                        }
                    }
                }
            }
            this.val = this.impozit11 + this.real_impozit + this.joc_impozit + this.str_dif_impozit_datorat + oblig_realizat._real_impozit_datorat_f;
            if (oblig_realizat._oblimpoz_real_total != null && oblig_realizat._oblimpoz_real_total_f != this.val) {
                this._validator.addError(1, "R41", "", this._validator.fillParams("oblimpoz_real_total  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_realizat._oblimpoz_real_total_f), Long.toString(this.val)}));
            }
            for (n2 = 0; n2 < this._validator._cntCap16; ++n2) {
                this.indemnizatie16_impozit += this._validator._cap16[n2]._indemnizatie16_impozit_f;
            }
            if (oblig_realizat._oblimpoz_real_indemnizatie16 != null && oblig_realizat._oblimpoz_real_indemnizatie16_f != this.indemnizatie16_impozit) {
                this._validator.addError(1, "R43", "", this._validator.fillParams("oblimpoz_real_indemnizatie16  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_realizat._oblimpoz_real_indemnizatie16_f), Long.toString(this.indemnizatie16_impozit)}));
            }
            for (n2 = 0; n2 < this._validator._cntCap17; ++n2) {
                this.indemnizatie17_impozit += this._validator._cap17[n2]._indemnizatie17_impozit_f;
            }
            if (oblig_realizat._oblimpoz_real_indemnizatie17 != null && oblig_realizat._oblimpoz_real_indemnizatie17_f != this.indemnizatie17_impozit) {
                this._validator.addError(1, "R44", "", this._validator.fillParams("oblimpoz_real_indemnizatie17  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_realizat._oblimpoz_real_indemnizatie17_f), Long.toString(this.indemnizatie17_impozit)}));
            }
            for (n2 = 0; n2 < this._validator._cntCap16; ++n2) {
                this.indemnizatie16_cas += this._validator._cap16[n2]._indemnizatie16_cas_f;
            }
            if (oblig_realizat._oblcas_real_indemnizatie16 != null && oblig_realizat._oblcas_real_indemnizatie16_f != this.indemnizatie16_cas) {
                this._validator.addError(1, "R46", "", this._validator.fillParams("oblcas_real_indemnizatie16  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_realizat._oblcas_real_indemnizatie16_f), Long.toString(this.indemnizatie16_cas)}));
            }
            for (n2 = 0; n2 < this._validator._cntCap17; ++n2) {
                this.indemnizatie17_cas += this._validator._cap17[n2]._indemnizatie17_cas_f;
            }
            if (oblig_realizat._oblcas_real_indemnizatie17 != null && oblig_realizat._oblcas_real_indemnizatie17_f != this.indemnizatie17_cas) {
                this._validator.addError(1, "R47", "", this._validator.fillParams("oblcas_real_indemnizatie17  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_realizat._oblcas_real_indemnizatie17_f), Long.toString(this.indemnizatie17_cas)}));
            }
            for (n2 = 0; n2 < this._validator._cntCap16; ++n2) {
                this.indemnizatie16_cass += this._validator._cap16[n2]._indemnizatie16_cass_f;
            }
            if (oblig_realizat._oblcass_real_indemnizatie16 != null && oblig_realizat._oblcass_real_indemnizatie16_f != this.indemnizatie16_cass) {
                this._validator.addError(1, "R49", "", this._validator.fillParams("oblcass_real_indemnizatie16  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_realizat._oblcass_real_indemnizatie16_f), Long.toString(this.indemnizatie16_cass)}));
            }
            for (n2 = 0; n2 < this._validator._cntCap17; ++n2) {
                this.indemnizatie17_cass += this._validator._cap17[n2]._indemnizatie17_cass_f;
            }
            if (oblig_realizat._oblcass_real_indemnizatie16 != null && oblig_realizat._oblcass_real_indemnizatie17_f != this.indemnizatie17_cass) {
                this._validator.addError(1, "R50", "", this._validator.fillParams("oblcass_real_indemnizatie17  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_realizat._oblcass_real_indemnizatie17_f), Long.toString(this.indemnizatie17_cass)}));
            }
        }
        if (this._validator._existsOblig_estimat) {
            this.val = this.estr_impozit_venit + this.estn_impozit + oblig_estimat._estan_tot_impozit_anual_f;
            if (oblig_estimat._oblimpoz_est_total != null && oblig_estimat._oblimpoz_est_total_f != this.val) {
                this._validator.addError(1, "R67", "", this._validator.fillParams("oblimpoz_est_total  (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_estimat._oblimpoz_est_total_f), Long.toString(this.val)}));
            }
        }
        if (this._validator._existsOblig_estimat) {
            for (n2 = 0; n2 < this._validator._cntCap23; ++n2) {
                cap23 = this._validator._cap23[n2];
                if (oblig_estimat._estan_tot_ven_impoz != null) continue;
                this._validator.addError(1, "R75", "", this._validator.fillParams("Daca exista cap23 atunci estan_tot_ven_impoz este obligatoriu", new Object[0]));
            }
            long l = 0L;
            l = Math.round(0.1 * (double)oblig_estimat._estan_tot_ven_impoz_f);
            if (oblig_estimat._estan_tot_impozit_anual != null && oblig_estimat._estan_tot_impozit_anual_f != l) {
                this._validator.addError(1, "R76", "", this._validator.fillParams("Daca exista cap23 atunci estan_tot_impozit_anual (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(oblig_estimat._estan_tot_impozit_anual_f), Long.toString(l)}));
            }
        }
        if (this.is1012 > 1L) {
            this._validator.addError(1, "Rcap11", "", this._validator.fillParams("categ_venit=1012 nu poate avea aparitii multiple in sectiunea cap11", new Object[0]));
        }
        if (this._d_rec_f == 0L && this._rectif1_f + this._rectif2_f > 0L || this._d_rec_f == 1L && this._rectif1_f + this._rectif2_f == 0L) {
            this._validator.addError(1, "R5", "", this._validator.fillParams("Pentru declaratie rectificativa trebuie selectata cel putin una dintre cele 2 bife de rectificative", new Object[0]));
        }
        if (this._cif.length() == 13) {
            this.val = Integer.parseInt(this._cif.substring(0, 1)) + Integer.parseInt(this._cif.substring(1, 2)) + Integer.parseInt(this._cif.substring(2, 3)) + Integer.parseInt(this._cif.substring(3, 4)) + Integer.parseInt(this._cif.substring(4, 5)) + Integer.parseInt(this._cif.substring(5, 6)) + Integer.parseInt(this._cif.substring(6, 7)) + Integer.parseInt(this._cif.substring(7, 8)) + Integer.parseInt(this._cif.substring(8, 9)) + Integer.parseInt(this._cif.substring(9, 10)) + Integer.parseInt(this._cif.substring(10, 11)) + Integer.parseInt(this._cif.substring(11, 12)) + Integer.parseInt(this._cif.substring(12, 13));
            if (this._totalPlata_A_f != this.val) {
                this._validator.addError(1, "R6", "", this._validator.fillParams("totalPlata_A (@0@) diferit de suma calculata (@1@)", new Object[]{Long.toString(this._totalPlata_A_f), Long.toString(this.val)}));
            }
        }
        if (this._nume_c != null && this._nume_c.length() < 2) {
            this._validator.addError(1, "R7", "", this._validator.fillParams("Nume contribuabil trebuie sa aiba o lungime mai mare de 2 caractere", new Object[0]));
        }
        if (this._nerezident_f == 1L && this._stat_rezidenta == null) {
            this._validator.addError(1, "R13", "", this._validator.fillParams("Pentru nerezidenti statul de rezidenta este obligatoriu", new Object[0]));
        }
        if (this._nerezident_f == 0L && this._stat_rezidenta != null) {
            this._validator.addError(1, "R14", "", this._validator.fillParams("Pentru persoanele care nu sunt nerezidente statul de rezidenta trebuie sa fie null", new Object[0]));
        }
        if (this._nerezident_f == 0L && this._cif_str != null) {
            this._validator.addError(1, "R15", "", this._validator.fillParams("Pentru persoanele care nu sunt nerezidente CIF-ul din statul de rezidenta trebuie sa fie null", new Object[0]));
        }
        if (this._nerezident_f == 1L && this._cif_str == null) {
            this._validator.addError(1, "R15", "", this._validator.fillParams("Pentru persoanele care sunt nerezidente CIF-ul din statul de rezidenta este obligatoriu", new Object[0]));
        }
        if (this._cont_bancar != null && this._validator.checkIban(this._cont_bancar) < 0) {
            this._validator.addError(1, "R16", "", this._validator.fillParams("cont IBAN = @0@ este incorect", new Object[]{this._cont_bancar}));
        }
        if (this._rectif1_f + this._rectif2_f == 0L && this.nr_cap11 + this.nr_cap12 + this.nr_cap14 + this.nr_cap15 + this.nr_cap16 + this.nr_cap17 + this.nr_cap21 + this.nr_cap22 + this.nr_cap23 + this.nr_d212_oblig_est + this.nr_d212_oblig_real == 0L) {
            this._validator.addError(1, "Rdec", "", this._validator.fillParams("declaratia nu contine date in niciun capitol", new Object[0]));
        }
    }

    public void initialization() {
        this._listaUnicitateBifaDestinatie.clear();
        this._listaPerechiCategVenit.clear();
        this._listaPerechiNormaCategVenit.clear();
        this._listaPerechiEstrCategVenit.clear();
        this._listaPerechiEstnCategVenit.clear();
        this._listaPerechiEstanUnicitate.clear();
        this._luna_r = null;
        this._luna_r_f = 0L;
        this._luna_r_ok = false;
        this._an_r = null;
        this._an_r_f = 0L;
        this._an_r_ok = false;
        this._rectif1 = null;
        this._rectif1_f = 0L;
        this._rectif1_ok = false;
        this._rectif2 = null;
        this._rectif2_f = 0L;
        this._rectif2_ok = false;
        this._d_rec = null;
        this._d_rec_f = 0L;
        this._d_rec_ok = false;
        this._nume_c = null;
        this._nume_c_ok = false;
        this._adresa_c = null;
        this._adresa_c_ok = false;
        this._telefon_c = null;
        this._telefon_c_ok = false;
        this._fax_c = null;
        this._fax_c_ok = false;
        this._email_c = null;
        this._email_c_ok = false;
        this._cif = null;
        this._cif_f = 0L;
        this._cif_ok = false;
        this._totalPlata_A = null;
        this._totalPlata_A_f = 0L;
        this._totalPlata_A_ok = false;
        this._nerezident = null;
        this._nerezident_f = 0L;
        this._nerezident_ok = false;
        this._stat_rezidenta = null;
        this._stat_rezidenta_ok = false;
        this._cif_str = null;
        this._cif_str_ok = false;
        this._cont_bancar = null;
        this._cont_bancar_ok = false;
        this._den_i = null;
        this._den_i_ok = false;
        this._cif_i = null;
        this._cif_i_f = 0L;
        this._cif_i_ok = false;
        this._adresa_i = null;
        this._adresa_i_ok = false;
        this._telefon_i = null;
        this._telefon_i_ok = false;
        this._fax_i = null;
        this._fax_i_ok = false;
        this._email_i = null;
        this._email_i_ok = false;
        this.nr_cap11 = 0L;
        this.nr_cap12 = 0L;
        this.nr_cap14 = 0L;
        this.nr_cap15 = 0L;
        this.nr_cap16 = 0L;
        this.nr_cap17 = 0L;
        this.nr_cap21 = 0L;
        this.nr_cap22 = 0L;
        this.nr_cap23 = 0L;
        this.nr_d212_oblig_real = 0L;
        this.nr_d212_oblig_est = 0L;
        this.is1012 = 0L;
        this.venit_recalculat = 0L;
        this.impozit11 = 0L;
        this.real_impozit = 0L;
        this.joc_impozit = 0L;
        this.str_dif_impozit_datorat = 0L;
        this.estr_impozit_venit = 0L;
        this.estn_impozit = 0L;
        this.listaBifa = null;
        this.indemnizatie16_impozit = 0L;
        this.indemnizatie17_impozit = 0L;
        this.indemnizatie16_cas = 0L;
        this.indemnizatie17_cas = 0L;
        this.indemnizatie16_cass = 0L;
        this.indemnizatie17_cass = 0L;
    }
}

