/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_AT
implements ValidationRoutine {
    static final int LENGTH = 9;

    private boolean checkSumOk(String vatNumber) {
        int i;
        int accu = 4;
        for (i = 2; i <= 6; i += 2) {
            int res = 2 * StringUtils.digitAt(vatNumber, i);
            if (res >= 10) {
                res -= 9;
            }
            accu += res;
        }
        for (i = 1; i <= 7; i += 2) {
            accu += StringUtils.digitAt(vatNumber, i);
        }
        int res = accu % 10;
        if (res != 0) {
            res = 10 - res;
        }
        return StringUtils.digitAt(vatNumber, 8) == res;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 9 && vatNumber.startsWith("U") && StringUtils.isNum(vatNumber.substring(1)) && this.checkSumOk(vatNumber);
    }
}

