/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.DateUtils;
import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_BG
implements ValidationRoutine {
    static final int LENGTH_LEGAL_ENTITIES = 9;
    static final int LENGTH_OTHER_ENTITIES = 10;

    private boolean checkSumAlgo1Ok(String vatNumber) {
        int res = 1 * StringUtils.digitAt(vatNumber, 0) + 2 * StringUtils.digitAt(vatNumber, 1) + 3 * StringUtils.digitAt(vatNumber, 2) + 4 * StringUtils.digitAt(vatNumber, 3) + 5 * StringUtils.digitAt(vatNumber, 4) + 6 * StringUtils.digitAt(vatNumber, 5) + 7 * StringUtils.digitAt(vatNumber, 6) + 8 * StringUtils.digitAt(vatNumber, 7);
        if ((res %= 11) == 10) {
            res = 3 * StringUtils.digitAt(vatNumber, 0) + 4 * StringUtils.digitAt(vatNumber, 1) + 5 * StringUtils.digitAt(vatNumber, 2) + 6 * StringUtils.digitAt(vatNumber, 3) + 7 * StringUtils.digitAt(vatNumber, 4) + 8 * StringUtils.digitAt(vatNumber, 5) + 9 * StringUtils.digitAt(vatNumber, 6) + 10 * StringUtils.digitAt(vatNumber, 7);
            if ((res %= 11) == 10) {
                res = 0;
            }
            return res == StringUtils.digitAt(vatNumber, 8);
        }
        return res == StringUtils.digitAt(vatNumber, 8);
    }

    private boolean checkSumAlgo2Ok(String vatNumber) {
        int year = 10 * StringUtils.digitAt(vatNumber, 0) + StringUtils.digitAt(vatNumber, 1);
        int month = 10 * StringUtils.digitAt(vatNumber, 2) + StringUtils.digitAt(vatNumber, 3);
        if (month >= 21 && month <= 32) {
            year += 1800;
            month -= 20;
        } else if (month >= 41 && month <= 52) {
            year += 2000;
            month -= 40;
        } else if (month >= 1 && month <= 12) {
            year += 1900;
        } else {
            return false;
        }
        int day = 10 * StringUtils.digitAt(vatNumber, 4) + StringUtils.digitAt(vatNumber, 5);
        if (!DateUtils.validate(year, month, day)) {
            return false;
        }
        int res = 2 * StringUtils.digitAt(vatNumber, 0) + 4 * StringUtils.digitAt(vatNumber, 1) + 8 * StringUtils.digitAt(vatNumber, 2) + 5 * StringUtils.digitAt(vatNumber, 3) + 10 * StringUtils.digitAt(vatNumber, 4) + 9 * StringUtils.digitAt(vatNumber, 5) + 7 * StringUtils.digitAt(vatNumber, 6) + 3 * StringUtils.digitAt(vatNumber, 7) + 6 * StringUtils.digitAt(vatNumber, 8);
        if ((res %= 11) == 10) {
            res = 0;
        }
        return res == StringUtils.digitAt(vatNumber, 9);
    }

    private boolean checkSumAlgo3Ok(String vatNumber) {
        int res = 21 * StringUtils.digitAt(vatNumber, 0) + 19 * StringUtils.digitAt(vatNumber, 1) + 17 * StringUtils.digitAt(vatNumber, 2) + 13 * StringUtils.digitAt(vatNumber, 3) + 11 * StringUtils.digitAt(vatNumber, 4) + 9 * StringUtils.digitAt(vatNumber, 5) + 7 * StringUtils.digitAt(vatNumber, 6) + 3 * StringUtils.digitAt(vatNumber, 7) + 1 * StringUtils.digitAt(vatNumber, 8);
        return (res %= 10) == StringUtils.digitAt(vatNumber, 9);
    }

    private boolean checkSumAlgo4Ok(String vatNumber) {
        int res = 4 * StringUtils.digitAt(vatNumber, 0) + 3 * StringUtils.digitAt(vatNumber, 1) + 2 * StringUtils.digitAt(vatNumber, 2) + 7 * StringUtils.digitAt(vatNumber, 3) + 6 * StringUtils.digitAt(vatNumber, 4) + 5 * StringUtils.digitAt(vatNumber, 5) + 4 * StringUtils.digitAt(vatNumber, 6) + 3 * StringUtils.digitAt(vatNumber, 7) + 2 * StringUtils.digitAt(vatNumber, 8);
        if ((res = 11 - res % 11) == 11) {
            res = 0;
        }
        if (res == 10) {
            return false;
        }
        return res == StringUtils.digitAt(vatNumber, 9);
    }

    @Override
    public boolean check(String vatNumber) {
        if (!StringUtils.isNum(vatNumber)) {
            return false;
        }
        if (vatNumber.length() != 9 && vatNumber.length() != 10) {
            return false;
        }
        if (vatNumber.length() == 9) {
            return this.checkSumAlgo1Ok(vatNumber);
        }
        if (this.checkSumAlgo2Ok(vatNumber)) {
            return true;
        }
        if (this.checkSumAlgo3Ok(vatNumber)) {
            return true;
        }
        return this.checkSumAlgo4Ok(vatNumber);
    }
}

