/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_CY
implements ValidationRoutine {
    static final int LENGTH = 9;

    private int compute(int digit) {
        int[] map = new int[]{1, 0, 5, 7, 9, 13, 15, 17, 19, 21};
        return map[digit];
    }

    private char computeCheckDigit(int checkDigit) {
        String map = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        if (checkDigit >= 0 && checkDigit <= "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length() - 1) {
            return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(checkDigit);
        }
        return '?';
    }

    private boolean checkSumOk(String vatNumber, char checkDigit) {
        if (StringUtils.digitAt(vatNumber, 0) == 1 && StringUtils.digitAt(vatNumber, 1) == 2) {
            return false;
        }
        int res = this.compute(StringUtils.digitAt(vatNumber, 0)) + StringUtils.digitAt(vatNumber, 1) + this.compute(StringUtils.digitAt(vatNumber, 2)) + StringUtils.digitAt(vatNumber, 3) + this.compute(StringUtils.digitAt(vatNumber, 4)) + StringUtils.digitAt(vatNumber, 5) + this.compute(StringUtils.digitAt(vatNumber, 6)) + StringUtils.digitAt(vatNumber, 7);
        return this.computeCheckDigit(res %= 26) == checkDigit;
    }

    @Override
    public boolean check(String vatNumber) {
        if (vatNumber.length() != 9) {
            return false;
        }
        char checkDigit = vatNumber.charAt(8);
        if (!Character.isLetter(checkDigit)) {
            return false;
        }
        String digit_part = vatNumber.substring(0, 8);
        if (!StringUtils.isNum(digit_part) || "013459".indexOf(vatNumber.charAt(0)) == -1) {
            return false;
        }
        return this.checkSumOk(digit_part, checkDigit);
    }
}

