/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.DateUtils;
import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;
import java.util.GregorianCalendar;

public class CheckVat_CZ
implements ValidationRoutine {
    static final int LENGTH_1 = 8;
    static final int LENGTH_2 = 9;
    static final int LENGTH_3 = 10;

    private boolean checkRoutine1(String vatNumber) {
        if (vatNumber.charAt(0) == '9') {
            return false;
        }
        double res = 0.0;
        for (int i = 0; i < 7; ++i) {
            res += (double)((8 - i) * StringUtils.digitAt(vatNumber, i));
        }
        if ((res = Math.ceil(res / 11.0) * 11.0 - res) == 0.0) {
            res = 1.0;
        }
        if (res == 10.0) {
            res = 0.0;
        }
        return (double)StringUtils.digitAt(vatNumber, 7) == res;
    }

    private boolean checkRoutine2(String vatNumber) {
        int year = StringUtils.substrToInt(vatNumber, 0, 2);
        int month = StringUtils.substrToInt(vatNumber, 2, 4);
        int day = StringUtils.substrToInt(vatNumber, 4, 6);
        if (year > 53) {
            return false;
        }
        if (month > 50) {
            month -= 50;
        }
        return DateUtils.validate(year, month, day);
    }

    private boolean checkRoutine3(String vatNumber) {
        double res = 0.0;
        for (int i = 0; i < 7; ++i) {
            res += (double)((8 - i) * StringUtils.digitAt(vatNumber, i + 1));
        }
        res = Math.ceil(res / 11.0) * 11.0 - res;
        int resint = (int)res;
        int[] map = new int[]{8, 8, 7, 6, 5, 4, 3, 2, 1, 0, 9, 8};
        if (resint >= 0 && resint <= 11) {
            return StringUtils.digitAt(vatNumber, 8) == map[resint];
        }
        return false;
    }

    private boolean checkRoutine4(String vatNumber) {
        int year = StringUtils.substrToInt(vatNumber, 0, 2);
        int month = StringUtils.substrToInt(vatNumber, 2, 4);
        int day = StringUtils.substrToInt(vatNumber, 4, 6);
        GregorianCalendar calendar = new GregorianCalendar();
        int myYear = calendar.get(1);
        if (year < 54 && myYear < year + 2000) {
            return false;
        }
        int res = year + month + day + StringUtils.substrToInt(vatNumber, 6, 8) + StringUtils.substrToInt(vatNumber, 8, 10);
        return DateUtils.validate(year += year > 53 ? 1900 : 2000, month -= (month -= month > 50 ? 50 : 0) >= 21 && month <= 32 ? 20 : 0, day) && (res %= 11) == 0;
    }

    @Override
    public boolean check(String vatNumber) {
        if (!StringUtils.isNum(vatNumber)) {
            return false;
        }
        switch (vatNumber.length()) {
            case 8: {
                return this.checkRoutine1(vatNumber);
            }
            case 9: {
                if (vatNumber.charAt(0) != '6') {
                    return this.checkRoutine2(vatNumber);
                }
                return this.checkRoutine3(vatNumber);
            }
            case 10: {
                return this.checkRoutine4(vatNumber);
            }
        }
        return false;
    }
}

