/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_DE
implements ValidationRoutine {
    static final int LENGTH = 9;

    private boolean checkSumOk(String vatNumber) {
        int num = StringUtils.digitAt(vatNumber, 0);
        if (num == 0) {
            return false;
        }
        int val = 10;
        int mod = 0;
        for (int i = 0; i < 8; ++i) {
            mod = (val += StringUtils.digitAt(vatNumber, i)) % 10;
            if (mod == 0) {
                mod = 10;
            }
            val = 2 * mod % 11;
        }
        mod = 11 - val;
        if (mod == 10) {
            mod = 0;
        }
        return mod == StringUtils.digitAt(vatNumber, 8);
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 9 && StringUtils.isNum(vatNumber) && this.checkSumOk(vatNumber);
    }
}

