/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_EL
implements ValidationRoutine {
    static final int LENGTH = 9;

    private boolean checkSumOk(String vatNumber) {
        if (Integer.parseInt(vatNumber) == 0) {
            return false;
        }
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            res = (int)((double)res + Math.pow(2.0, 8 - i) * (double)StringUtils.digitAt(vatNumber, i));
        }
        int mod = res % 11;
        if (mod == 10) {
            mod = 0;
        }
        return mod == StringUtils.digitAt(vatNumber, 8);
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 9 && StringUtils.isNum(vatNumber) && this.checkSumOk(vatNumber);
    }
}

