/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_ES
implements ValidationRoutine {
    static final int LENGTH = 9;

    public int modFor1and2(String vatNumber) {
        int accu = 0;
        for (int i = 0; i <= 6; i += 2) {
            int res = 2 * StringUtils.digitAt(vatNumber, i);
            if (res >= 10) {
                res -= 9;
            }
            accu += res;
        }
        return (StringUtils.digitAt(vatNumber, 1) + StringUtils.digitAt(vatNumber, 3) + StringUtils.digitAt(vatNumber, 5) + accu) % 10;
    }

    public boolean checkRoutine1(String vatNumber) {
        int mod = this.modFor1and2(vatNumber);
        if (mod > 0) {
            mod = 10 - mod;
        }
        return mod == StringUtils.digitAt(vatNumber, vatNumber.length() - 1);
    }

    public boolean checkRoutine2(String vatNumber, char last) {
        int value = Integer.parseInt(vatNumber);
        int mod = value % 23;
        return "TRWAGMYFPDXBNJZSQVHLCKE".charAt(mod) == last;
    }

    public boolean checkRoutine3(String vatNumber, char last) {
        int mod = 9 - this.modFor1and2(vatNumber);
        return "ABCDEFGHIJ".charAt(mod) == last;
    }

    public boolean lastCharIsDigitOk(char first, char last, String digit_part) {
        if ("ABCDEFGHJUV".indexOf(first) != -1) {
            return this.checkRoutine1(digit_part + last);
        }
        return false;
    }

    public boolean lastCharIsAlphaOk(char first, char last, String digit_part) {
        if ("ABCDEFGHNPQRSW".indexOf(first) != -1) {
            return this.checkRoutine3(digit_part, last);
        }
        if ("Y".indexOf(first) != -1) {
            first = (char)49;
        }
        if ("Z".indexOf(first) != -1) {
            first = (char)50;
        }
        if (Character.isDigit(first)) {
            return this.checkRoutine2(first + digit_part, last);
        }
        if ("KLMX".indexOf(first) != -1) {
            return this.checkRoutine2(digit_part, last);
        }
        return false;
    }

    public boolean checkSumOk(char first, char last, String digit_part) {
        if (Character.isDigit(last)) {
            return this.lastCharIsDigitOk(first, last, digit_part);
        }
        return this.lastCharIsAlphaOk(first, last, digit_part);
    }

    @Override
    public boolean check(String vatNumber) {
        if (vatNumber.length() != 9) {
            return false;
        }
        char first_char = vatNumber.charAt(0);
        char last_char = vatNumber.charAt(8);
        String digit_part = vatNumber.substring(1, 8);
        return StringUtils.isNum(digit_part) && Integer.parseInt(digit_part) != 0 && this.checkSumOk(first_char, last_char, digit_part);
    }
}

