/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.ISOUtils;
import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_EU
implements ValidationRoutine {
    static final int LENGTH = 9;
    static final int FROM = 0;
    static final int LENGTH_ISO = 3;

    private boolean checkSumOk(String vatNumber) {
        int nA1 = 0;
        for (int i = 0; i < 8; ++i) {
            nA1 += (8 - i) * StringUtils.digitAt(vatNumber, i);
        }
        int nR = nA1 % 11;
        int nC9 = StringUtils.digitAt(vatNumber, 8);
        return nR == 10 && nC9 == 1 || nR != 10 && nC9 == nR;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 9 && StringUtils.isNum(vatNumber) && ISOUtils.isISO3166(vatNumber.substring(0, 3)) && this.checkSumOk(vatNumber);
    }
}

