/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_FI
implements ValidationRoutine {
    static final int LENGTH = 8;

    private boolean checkSumOk(String vatNumber) {
        int res = 7 * StringUtils.digitAt(vatNumber, 0) + 9 * StringUtils.digitAt(vatNumber, 1) + 10 * StringUtils.digitAt(vatNumber, 2) + 5 * StringUtils.digitAt(vatNumber, 3) + 8 * StringUtils.digitAt(vatNumber, 4) + 4 * StringUtils.digitAt(vatNumber, 5) + 2 * StringUtils.digitAt(vatNumber, 6);
        int mod = res % 11;
        if (mod == 1) {
            return false;
        }
        if (mod > 0) {
            mod = 11 - mod;
        }
        return StringUtils.digitAt(vatNumber, 7) == mod;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 8 && StringUtils.isNum(vatNumber) && this.checkSumOk(vatNumber);
    }
}

