/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_FR
implements ValidationRoutine {
    static final int LENGTH = 11;
    static final String checkChars = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ";

    private boolean checkSumOk(String vatNumber) {
        int num = StringUtils.substrToInt(vatNumber, 2, 11);
        if (num == 0) {
            return false;
        }
        String key = vatNumber.substring(0, 2);
        String sir = vatNumber.substring(2);
        if (StringUtils.isNum(key)) {
            double vat_check = Double.parseDouble(key);
            double vat_number = Double.parseDouble(sir + "12");
            return vat_number % 97.0 == vat_check;
        }
        long z1 = checkChars.indexOf(vatNumber.charAt(0));
        long z2 = checkChars.indexOf(vatNumber.charAt(1));
        long tmp_res = 0L;
        tmp_res = z1 > 9L ? 34L * z1 + z2 - 100L : 24L * z1 + z2 - 10L;
        double vat_check = tmp_res % 11L;
        double vat_number = Double.parseDouble(vatNumber.substring(2));
        return (vat_number += (double)(tmp_res / 11L + 1L)) % 11.0 == vat_check;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 11 && StringUtils.isNum(vatNumber.substring(2)) && checkChars.indexOf(vatNumber.charAt(0)) != -1 && checkChars.indexOf(vatNumber.charAt(1)) != -1 && this.checkSumOk(vatNumber);
    }
}

