/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_GB
implements ValidationRoutine {
    static final int LENGTH = 9;
    static final int LENGTH_GOV = 5;

    private boolean checkSumOk(String vatNumber) {
        int vat_check = StringUtils.substrToInt(vatNumber, 7, 9);
        int iVATnumber = StringUtils.substrToInt(vatNumber, 0, 7);
        if (vat_check > 96) {
            return false;
        }
        int res = 0;
        for (int i = 0; i < 7; ++i) {
            res += (8 - i) * StringUtils.digitAt(vatNumber, i);
        }
        boolean bmod97 = !((res + vat_check) % 97 != 0 || iVATnumber >= 100000 && iVATnumber <= 999999 || iVATnumber >= 9490001 && iVATnumber <= 9700000 || iVATnumber >= 9990001 && iVATnumber <= 9999999);
        boolean bmod9755 = !((res + vat_check + 55) % 97 != 0 || iVATnumber >= 1 && iVATnumber <= 32768 || iVATnumber >= 32769 && iVATnumber <= 1000000);
        return bmod97 ^ bmod9755;
    }

    private boolean checkSumGovOk(String vatNumber) {
        int num = StringUtils.substrToInt(vatNumber, 2);
        if (vatNumber.startsWith("GD")) {
            return num >= 0 && num <= 499;
        }
        if (vatNumber.startsWith("HA")) {
            return num >= 500 && num <= 999;
        }
        return false;
    }

    public boolean checkIsleOfMan(String vatNumber) {
        if (vatNumber.charAt(0) == '0') {
            return vatNumber.charAt(1) == '0';
        }
        return true;
    }

    @Override
    public boolean check(String vatNumber) {
        if (vatNumber.length() == 5) {
            return StringUtils.isNum(vatNumber.substring(2)) && this.checkSumGovOk(vatNumber);
        }
        if (vatNumber.length() != 9 && (vatNumber.length() != 12 || vatNumber.endsWith("000"))) {
            return false;
        }
        if (vatNumber.startsWith("000000000")) {
            return false;
        }
        return StringUtils.isNum(vatNumber) && this.checkIsleOfMan(vatNumber) && this.checkSumOk(vatNumber);
    }
}

