/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_HR
implements ValidationRoutine {
    static final int LENGTH = 11;

    private boolean checkSumOk(String vatNumber) {
        int p = 10;
        int sum = 0;
        for (int i = 0; i < 10; ++i) {
            sum = StringUtils.digitAt(vatNumber, i) + p;
            int m = sum % 10;
            if (m == 0) {
                m = 10;
            }
            p = 2 * m % 11;
        }
        int r = 11 - p;
        return r == 10 && StringUtils.digitAt(vatNumber, 10) == 0 || r == StringUtils.digitAt(vatNumber, 10);
    }

    @Override
    public boolean check(String vatNumber) {
        if (vatNumber.length() != 11) {
            return false;
        }
        return this.checkSumOk(vatNumber);
    }
}

