/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_HU
implements ValidationRoutine {
    static final int LENGTH = 8;

    private boolean checkSumOk(String vatNumber) {
        double res = 9 * StringUtils.digitAt(vatNumber, 0) + 7 * StringUtils.digitAt(vatNumber, 1) + 3 * StringUtils.digitAt(vatNumber, 2) + 1 * StringUtils.digitAt(vatNumber, 3) + 9 * StringUtils.digitAt(vatNumber, 4) + 7 * StringUtils.digitAt(vatNumber, 5) + 3 * StringUtils.digitAt(vatNumber, 6);
        if (res == 0.0) {
            return false;
        }
        res = Math.ceil(res / 10.0) * 10.0 - res;
        return (double)StringUtils.digitAt(vatNumber, 7) == res;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 8 && StringUtils.isNum(vatNumber) && this.checkSumOk(vatNumber);
    }
}

