/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_IE
implements ValidationRoutine {
    static final int LENGTH_9 = 9;
    static final int LENGTH_8 = 8;
    static final String letterToNumberC9 = "ABCDEFGHI";

    private boolean checkSumOk(String vatNumber, int vatLength) {
        int mod;
        int res = 0;
        for (int i = 0; i < 7; ++i) {
            res += (8 - i) * StringUtils.digitAt(vatNumber, i);
        }
        if (vatLength == 9) {
            res += 9 * (letterToNumberC9.indexOf(vatNumber.substring(8)) + 1);
        }
        return "WABCDEFGHIJKLMNOPQRSTUV".charAt(mod = res % 23) == vatNumber.charAt(7);
    }

    private boolean checkOldSumOk(String vatNumber) {
        int res = 0;
        for (int i = 0; i < 7; ++i) {
            res += (8 - i) * StringUtils.digitAt(vatNumber, i);
        }
        int mod = res % 23;
        return "WABCDEFGHIJKLMNOPQRSTUV".charAt(mod) == vatNumber.charAt(vatNumber.length() - 1);
    }

    private boolean checkOldStyle(String digit_part, char first_char, char second_char, char last_char) {
        if ((Character.isLetter(second_char) || second_char == '+' || second_char == '*') && first_char >= '7') {
            String string_to_test = "0" + digit_part + first_char + last_char;
            return this.checkOldSumOk(string_to_test);
        }
        return false;
    }

    @Override
    public boolean check(String vatNumber) {
        if (vatNumber.length() < 8) {
            return false;
        }
        char first_char = vatNumber.charAt(0);
        char second_char = vatNumber.charAt(1);
        if (vatNumber.length() == 8) {
            char last_char = vatNumber.charAt(7);
            String digit_part = vatNumber.substring(2, 7);
            if (!(Character.isDigit(first_char) && StringUtils.isNum(digit_part) && Character.isLetter(last_char))) {
                return false;
            }
            if (!Character.isDigit(second_char)) {
                return this.checkOldStyle(digit_part, first_char, second_char, last_char);
            }
            return this.checkSumOk(vatNumber, 8);
        }
        if (vatNumber.length() == 9) {
            char last_char = vatNumber.charAt(8);
            String digit_part = vatNumber.substring(2, 7);
            if (!(Character.isDigit(first_char) && StringUtils.isNum(digit_part) && Character.isLetter(last_char))) {
                return false;
            }
            if (Character.isDigit(second_char)) {
                return this.checkSumOk(vatNumber, 9);
            }
        } else {
            return false;
        }
        return false;
    }
}

