/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_IT
implements ValidationRoutine {
    static final int LENGTH = 11;

    private boolean checkSumOk(String vatNumber) {
        int num = StringUtils.substrToInt(vatNumber, 0, 7);
        if (num == 0) {
            return false;
        }
        int vat_check_end = (StringUtils.substrToInt(vatNumber, 7) - StringUtils.digitAt(vatNumber, 10)) / 10;
        if (vat_check_end != 120 && vat_check_end != 121 && vat_check_end != 999 && vat_check_end != 888 && (vat_check_end > 100 || vat_check_end < 1)) {
            return false;
        }
        int vat_check = StringUtils.digitAt(vatNumber, 10);
        int accu = 0;
        int accu2 = 0;
        for (int i = 1; i < 10; i += 2) {
            int res = 2 * StringUtils.digitAt(vatNumber, i);
            if (res > 9) {
                res -= 9;
            }
            accu += res;
            accu2 += StringUtils.digitAt(vatNumber, i - 1);
        }
        int mod = (accu + accu2) % 10;
        if (mod > 0) {
            mod = 10 - mod;
        }
        return mod == vat_check;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 11 && StringUtils.isNum(vatNumber) && this.checkSumOk(vatNumber);
    }
}

