/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_LT
implements ValidationRoutine {
    static final int LENGTH1 = 9;
    static final int LENGTH2 = 12;

    private boolean checkSum1Ok(String vatNumber) {
        if (StringUtils.digitAt(vatNumber, 7) != 1) {
            return false;
        }
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            res += (i + 1) * StringUtils.digitAt(vatNumber, i);
        }
        if ((res %= 11) == 10) {
            res = 3 * StringUtils.digitAt(vatNumber, 0) + 4 * StringUtils.digitAt(vatNumber, 1) + 5 * StringUtils.digitAt(vatNumber, 2) + 6 * StringUtils.digitAt(vatNumber, 3) + 7 * StringUtils.digitAt(vatNumber, 4) + 8 * StringUtils.digitAt(vatNumber, 5) + 9 * StringUtils.digitAt(vatNumber, 6) + 1 * StringUtils.digitAt(vatNumber, 7);
            if ((res %= 11) == 10) {
                res = 0;
            }
        }
        return StringUtils.digitAt(vatNumber, 8) == res;
    }

    private boolean checkSum2Ok(String vatNumber) {
        if (StringUtils.digitAt(vatNumber, 10) != 1) {
            return false;
        }
        int res = 1 * StringUtils.digitAt(vatNumber, 0) + 2 * StringUtils.digitAt(vatNumber, 1) + 3 * StringUtils.digitAt(vatNumber, 2) + 4 * StringUtils.digitAt(vatNumber, 3) + 5 * StringUtils.digitAt(vatNumber, 4) + 6 * StringUtils.digitAt(vatNumber, 5) + 7 * StringUtils.digitAt(vatNumber, 6) + 8 * StringUtils.digitAt(vatNumber, 7) + 9 * StringUtils.digitAt(vatNumber, 8) + 1 * StringUtils.digitAt(vatNumber, 9) + 2 * StringUtils.digitAt(vatNumber, 10);
        if ((res %= 11) == 10) {
            res = 3 * StringUtils.digitAt(vatNumber, 0) + 4 * StringUtils.digitAt(vatNumber, 1) + 5 * StringUtils.digitAt(vatNumber, 2) + 6 * StringUtils.digitAt(vatNumber, 3) + 7 * StringUtils.digitAt(vatNumber, 4) + 8 * StringUtils.digitAt(vatNumber, 5) + 9 * StringUtils.digitAt(vatNumber, 6) + 1 * StringUtils.digitAt(vatNumber, 7) + 2 * StringUtils.digitAt(vatNumber, 8) + 3 * StringUtils.digitAt(vatNumber, 9) + 4 * StringUtils.digitAt(vatNumber, 10);
            if ((res %= 11) == 10) {
                res = 0;
            }
        }
        return StringUtils.digitAt(vatNumber, 11) == res;
    }

    @Override
    public boolean check(String vatNumber) {
        if (!StringUtils.isNum(vatNumber)) {
            return false;
        }
        if (vatNumber.length() == 9) {
            return this.checkSum1Ok(vatNumber);
        }
        if (vatNumber.length() == 12) {
            return this.checkSum2Ok(vatNumber);
        }
        return false;
    }
}

