/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.DateUtils;
import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_LV
implements ValidationRoutine {
    static final int LENGTH = 11;

    private boolean checkRoutine1Ok(String vatNumber) {
        int res = 9 * StringUtils.digitAt(vatNumber, 0) + 1 * StringUtils.digitAt(vatNumber, 1) + 4 * StringUtils.digitAt(vatNumber, 2) + 8 * StringUtils.digitAt(vatNumber, 3) + 3 * StringUtils.digitAt(vatNumber, 4) + 10 * StringUtils.digitAt(vatNumber, 5) + 2 * StringUtils.digitAt(vatNumber, 6) + 5 * StringUtils.digitAt(vatNumber, 7) + 7 * StringUtils.digitAt(vatNumber, 8) + 6 * StringUtils.digitAt(vatNumber, 9);
        if ((res = 3 - res % 11) < -1) {
            res += 11;
        } else if (res == -1) {
            return false;
        }
        return StringUtils.digitAt(vatNumber, 10) == res;
    }

    private boolean checkRoutine2Ok(String vatNumber) {
        int year;
        int day = StringUtils.substrToInt(vatNumber, 0, 2);
        int month = StringUtils.substrToInt(vatNumber, 2, 4);
        return DateUtils.validate(year += (year = StringUtils.substrToInt(vatNumber, 4, 6)) > 15 ? 1900 : 2000, month, day);
    }

    private boolean checkRoutine3Ok(String vatNumber) {
        return StringUtils.digitAt(vatNumber, 0) == 3 && StringUtils.digitAt(vatNumber, 1) == 2;
    }

    private boolean checkSumOk(String vatNumber) {
        if (StringUtils.digitAt(vatNumber, 0) > 3) {
            return this.checkRoutine1Ok(vatNumber);
        }
        return this.checkRoutine2Ok(vatNumber) || this.checkRoutine3Ok(vatNumber);
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 11 && StringUtils.isNum(vatNumber) && this.checkSumOk(vatNumber);
    }
}

