/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class CheckVat_NL
implements ValidationRoutine {
    static final int LENGTH = 12;
    private static final Map<String, String> CAPITAL_LETTERS_TO_INT = new HashMap<String, String>();

    private boolean modulo11Check(String vatNumber) {
        if (!StringUtils.isNum(vatNumber.substring(0, 9))) {
            return false;
        }
        if (vatNumber.charAt(9) != 'B') {
            return false;
        }
        if (!Character.isDigit(vatNumber.charAt(10)) || !Character.isDigit(vatNumber.charAt(11))) {
            return false;
        }
        if (StringUtils.substrToInt(vatNumber, 10) < 1) {
            return false;
        }
        int nA1 = 0;
        for (int i = 0; i < 8; ++i) {
            nA1 += (9 - i) * StringUtils.digitAt(vatNumber, i);
        }
        int nA2 = nA1 % 11;
        if (nA2 == 10) {
            return false;
        }
        return StringUtils.digitAt(vatNumber, 8) == nA2;
    }

    private boolean modulo97Check(String vatNumber) {
        if (!vatNumber.startsWith("NL")) {
            return false;
        }
        String c13c14String = vatNumber.substring(12, 13);
        if (!StringUtils.isNum(c13c14String)) {
            return false;
        }
        int c13c14 = StringUtils.digitAt(vatNumber, 12) * 10 + StringUtils.digitAt(vatNumber, 13);
        if (2 > c13c14 || c13c14 > 98) {
            return false;
        }
        String vatNumberAllDigits = vatNumber;
        for (Map.Entry<String, String> entry : CAPITAL_LETTERS_TO_INT.entrySet()) {
            String capitalLetter = entry.getKey();
            String value = entry.getValue();
            vatNumberAllDigits = vatNumberAllDigits.replace(capitalLetter, value);
        }
        if (!StringUtils.isNum(vatNumberAllDigits)) {
            return false;
        }
        return new BigInteger(vatNumberAllDigits).mod(new BigInteger("97")).equals(new BigInteger("1"));
    }

    @Override
    public boolean check(String vatNumber) {
        String modulo97VatNumber = "NL" + vatNumber;
        return vatNumber.length() == 12 && (this.modulo11Check(vatNumber) || this.modulo97Check(modulo97VatNumber));
    }

    static {
        CAPITAL_LETTERS_TO_INT.put("A", "10");
        CAPITAL_LETTERS_TO_INT.put("B", "11");
        CAPITAL_LETTERS_TO_INT.put("C", "12");
        CAPITAL_LETTERS_TO_INT.put("D", "13");
        CAPITAL_LETTERS_TO_INT.put("E", "14");
        CAPITAL_LETTERS_TO_INT.put("F", "15");
        CAPITAL_LETTERS_TO_INT.put("G", "16");
        CAPITAL_LETTERS_TO_INT.put("H", "17");
        CAPITAL_LETTERS_TO_INT.put("I", "18");
        CAPITAL_LETTERS_TO_INT.put("J", "19");
        CAPITAL_LETTERS_TO_INT.put("K", "20");
        CAPITAL_LETTERS_TO_INT.put("L", "21");
        CAPITAL_LETTERS_TO_INT.put("M", "22");
        CAPITAL_LETTERS_TO_INT.put("N", "23");
        CAPITAL_LETTERS_TO_INT.put("O", "24");
        CAPITAL_LETTERS_TO_INT.put("P", "25");
        CAPITAL_LETTERS_TO_INT.put("Q", "26");
        CAPITAL_LETTERS_TO_INT.put("R", "27");
        CAPITAL_LETTERS_TO_INT.put("S", "28");
        CAPITAL_LETTERS_TO_INT.put("T", "29");
        CAPITAL_LETTERS_TO_INT.put("U", "30");
        CAPITAL_LETTERS_TO_INT.put("V", "31");
        CAPITAL_LETTERS_TO_INT.put("W", "32");
        CAPITAL_LETTERS_TO_INT.put("X", "33");
        CAPITAL_LETTERS_TO_INT.put("Y", "34");
        CAPITAL_LETTERS_TO_INT.put("Z", "35");
        CAPITAL_LETTERS_TO_INT.put("+", "36");
        CAPITAL_LETTERS_TO_INT.put("*", "37");
    }
}

