/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_PT
implements ValidationRoutine {
    static final int LENGTH = 9;

    private boolean checkSumOk(String vatNumber) {
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            res += (9 - i) * StringUtils.digitAt(vatNumber, i);
        }
        int mod = 11 - res % 11;
        if (mod > 9) {
            mod = 0;
        }
        return StringUtils.digitAt(vatNumber, 8) == mod;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 9 && StringUtils.isNum(vatNumber) && vatNumber.charAt(0) != '0' && this.checkSumOk(vatNumber);
    }
}

