/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_SE
implements ValidationRoutine {
    static final int LENGTH = 12;

    private boolean checkSumOk(String vatNumber) {
        int res;
        int i;
        int lastDigits = StringUtils.substrToInt(vatNumber, 10);
        if (lastDigits < 1 || lastDigits > 94) {
            return false;
        }
        int accu = 0;
        for (i = 0; i <= 8; i += 2) {
            res = 2 * StringUtils.digitAt(vatNumber, i);
            if (res > 9) {
                res -= 9;
            }
            accu += res;
        }
        for (i = 1; i <= 7; i += 2) {
            accu += StringUtils.digitAt(vatNumber, i);
        }
        res = 10 - accu % 10;
        if (res == 10) {
            res = 0;
        }
        return StringUtils.digitAt(vatNumber, 9) == res;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 12 && StringUtils.isNum(vatNumber) && !vatNumber.endsWith("00") && this.checkSumOk(vatNumber);
    }
}

