/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_SI
implements ValidationRoutine {
    static final int LENGTH = 8;

    private boolean checkSumOk(String vatNumber) {
        int nA1 = 0;
        for (int i = 0; i < 7; ++i) {
            nA1 += (8 - i) * StringUtils.digitAt(vatNumber, i);
        }
        int nR = 11 - nA1 % 11;
        int nC8 = StringUtils.digitAt(vatNumber, 7);
        return (nR != 10 || nC8 == 0) && (nR == 10 || nR != 11 && nC8 == nR);
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 8 && StringUtils.isNum(vatNumber) && StringUtils.digitAt(vatNumber, 0) > 0 && this.checkSumOk(vatNumber);
    }
}

