/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

import cec.taxud.fiscalis.vies.common.vat.StringUtils;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;

public class CheckVat_SK
implements ValidationRoutine {
    static final int LENGTH = 10;

    private boolean checkSumOk(String vatNumber) {
        if (vatNumber.charAt(0) == '0' || "234789".indexOf(vatNumber.charAt(2)) == -1) {
            return false;
        }
        long check_sk_vat = StringUtils.substrToInt(vatNumber, 0, 3);
        long reminder = check_sk_vat % 11L;
        return (reminder = reminder * 10000000L + (long)StringUtils.substrToInt(vatNumber, 3)) % 11L == 0L;
    }

    @Override
    public boolean check(String vatNumber) {
        return vatNumber.length() == 10 && StringUtils.isNum(vatNumber) && this.checkSumOk(vatNumber);
    }
}

