/*
 * Decompiled with CFR 0.152.
 */
package cec.taxud.fiscalis.vies.common.vat;

public class DateUtils {
    private static final int JANUARY = 1;
    private static final int FEBRUARY = 2;
    private static final int DECEMBER = 12;

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private static int getLastDayOfMonth(int month, int year) {
        int[] lastDayOfMonth = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (month == 2 && DateUtils.isLeapYear(year)) {
            return 29;
        }
        return lastDayOfMonth[month];
    }

    public static boolean validate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            return false;
        }
        return day >= 1 && day <= DateUtils.getLastDayOfMonth(month, year);
    }
}

