/*
 * Decompiled with CFR 0.152.
 */
package d390validator.v0;

import cec.taxud.fiscalis.vies.common.VATValidation;
import d390validator.Parameters;
import d390validator.v0.DataObjectRoot;
import d390validator.v0.Declaratie390;
import d390validator.v0.ValidatorImpl;
import dec.DECConst;
import java.util.Arrays;

public class Operatie
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_OPERATIE = 0;
    String _tip;
    boolean _tip_ok;
    String _tara;
    boolean _tara_ok;
    String _codO;
    boolean _codO_ok;
    String _denO;
    boolean _denO_ok;
    String _baza;
    long _baza_f;
    boolean _baza_ok;

    public Operatie(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._tip = this._validator.nextAttributeInList(this._params._listaTipuri, "tip", 1, 4, 1);
        this._tip_ok = this._validator._attributeOK;
        this._tara = this._validator.nextAttributeInList(this._params._listaTari, "tara", 2, 4, 1);
        this._tara_ok = this._validator._attributeOK;
        this._codO = this._validator.nextAttribute("codO", 12, 4, 0);
        this._codO_ok = this._validator._attributeOK;
        this._denO = this._validator.nextAttribute("denO", 200, 4, 1);
        this._denO_ok = this._validator._attributeOK;
        this._baza = this._validator.nextAttributeInInterval(DECConst.M_LONG_18, DECConst.LONG_18, "baza", 0, 1, 1);
        this._baza_f = this._validator._integerValue;
        this._baza_ok = this._validator._attributeOK;
        this.endValidation(n);
    }

    public void aggregation(int n) {
        Declaratie390 declaratie390 = (Declaratie390)this._parent;
        char c = '\u0000';
        String string = null;
        int n2 = 0;
        if (this._tip_ok) {
            c = this._tip.charAt(0);
            switch (c) {
                case 'L': {
                    declaratie390._agg_bazaL += this._baza_f;
                    break;
                }
                case 'T': {
                    declaratie390._agg_bazaT += this._baza_f;
                    break;
                }
                case 'A': {
                    declaratie390._agg_bazaA += this._baza_f;
                    break;
                }
                case 'P': {
                    declaratie390._agg_bazaP += this._baza_f;
                    break;
                }
                case 'S': {
                    declaratie390._agg_bazaS += this._baza_f;
                }
            }
            if (this._tara_ok) {
                Parameters.IntrareUE intrareUE = new Parameters.IntrareUE();
                intrareUE._statMembru = this._tara;
                n2 = Arrays.binarySearch(this._params._intrareUE, intrareUE);
                if (n2 >= 0) {
                    intrareUE = this._params._intrareUE[n2];
                    if (declaratie390._an_f * 100L + declaratie390._luna_f < (long)intrareUE._perioada) {
                        this._validator.addError(1, "R23", "", this._validator.fillParams("Pentru statul Membru @0@ puteti depune o tranzactie numai incepand cu @1@.@2@", new Object[]{this._tara, Integer.toString(intrareUE._perioada % 100), Integer.toString(intrareUE._perioada / 100)}));
                    }
                }
                if (this._codO_ok && this._denO_ok) {
                    if (this._codO == null || this._codO.equals("")) {
                        if (c != 'A' && c != 'S') {
                            this._validator.addError(1, "R24.2", "codO necompletat pt. Tip in (L, T, P)", this._validator.fillParams("o tranzactie de tip '@0@' trebuie sa aibe codO completat", new Object[]{this._tip}));
                        }
                        if (declaratie390._denTipUnic.contains(string = this._tip + this._tara + this._denO)) {
                            this._validator.addError(1, "R24.4", "(tara + denO + tip) are aparitii multiple", this._validator.fillParams("operatorul din tara '@0@' cu denO = '@1@' nu poate avea decat o singura tranzactie de tip '@2@'", new Object[]{this._tara, this._denO, this._tip}));
                        } else {
                            declaratie390._denTipUnic.add(string);
                        }
                    } else {
                        String string2 = this._codO;
                        if (this._codO.toUpperCase().startsWith(this._tara)) {
                            string2 = this._codO.substring(2);
                        }
                        if (!VATValidation.check(string2, this._tara)) {
                            this._validator.addError(1, "R24.1", "codO invalid (nu respecta algoritmul de tara)", this._validator.fillParams("operatorul codO = '@1@' trebuie sa respecte algoritmul specific '@0@'", new Object[]{this._tara, string2}));
                        }
                        if (!this._tip.equals("A")) {
                            string = this._tip + this._tara + string2;
                            if (declaratie390._codTipUnic.contains(string)) {
                                this._validator.addError(1, "R24.3", "(tara + codO + tip) are aparitii multiple", this._validator.fillParams("operatorul din tara '@0@' cu codO = '@1@' nu poate avea decat o singura tranzactie de tip '@2@'", new Object[]{this._tara, this._codO, this._tip}));
                            } else {
                                declaratie390._codTipUnic.add(string);
                            }
                            string = declaratie390._denUnica.get(this._tara + string2);
                            if (string != null && !string.equals(this._denO)) {
                                this._validator.addError(1, "R25", "denumire operator completata diferit pentru acelasi cod operator", this._validator.fillParams("operatorul din tara '@0@' cu codO = '@1@' trebuie sa aiba o singura denumire ('@2@')", new Object[]{this._tara, this._codO, this._denO}));
                            } else if (string == null) {
                                declaratie390._denUnica.put(this._tara + string2, this._denO);
                            }
                        } else {
                            string = this._tara + string2 + ";" + this._denO;
                            if (declaratie390._codDenUnic.contains(string)) {
                                this._validator.addError(1, "R25.1", "", this._validator.fillParams("operatorul din tara '@0@' cu codO = '@1@' nu poate avea mai multe operatii de tip 'A' cu aceeasi denO '@2@'", new Object[]{this._tara, this._codO, this._denO}));
                            } else {
                                declaratie390._codDenUnic.add(string);
                            }
                        }
                    }
                }
            }
        }
    }

    public void initialization() {
        this._tip = null;
        this._tip_ok = false;
        this._tara = null;
        this._tara_ok = false;
        this._codO = null;
        this._codO_ok = false;
        this._denO = null;
        this._denO_ok = false;
        this._baza = null;
        this._baza_f = 0L;
        this._baza_ok = false;
    }
}

