/*
 * Decompiled with CFR 0.152.
 */
package d390validator.v2;

import cec.taxud.fiscalis.vies.common.VATValidation;
import d390validator.v2.DataObjectRoot;
import d390validator.v2.Declaratie390;
import d390validator.v2.ValidatorImpl;

public class Cos
extends DataObjectRoot {
    public static final int TAG_COUNT = 1;
    public static final int ID_INT_OPERATIE = 0;
    String _tip;
    boolean _tip_ok;
    String _tara_m1;
    boolean _tara_m1_ok;
    String _den_m1;
    String _cod_m1;
    boolean _cod_m1_ok;
    String _motiv;
    long _motiv_f;
    boolean _motiv_ok;
    String _tara_m2;
    boolean _tara_m2_ok;
    String _den_m2;
    String _cod_m2;
    boolean _cod_m2_ok;

    public Cos(ValidatorImpl validatorImpl, DataObjectRoot dataObjectRoot) {
        super(validatorImpl, dataObjectRoot, 1);
    }

    public void checkTag(int n) {
        this.startValidation(n);
        this._tip = this._validator.nextAttributeInList(this._params._listaTip1, "tip", 1, 4, 1);
        this._tip_ok = this._validator._attributeOK;
        this._tara_m1 = this._validator.nextAttributeInList(this._params._listaTari, "tara_m1", 2, 4, 1);
        this._tara_m1_ok = this._validator._attributeOK;
        this._cod_m1 = this._validator.nextAttribute("cod_m1", 12, 4, 1);
        this._cod_m1_ok = this._validator._attributeOK;
        if (this._tip != null) {
            if (this._tip.equals("A")) {
                this._motiv = this._validator.nextAttributeInInterval(1L, 2L, "motiv", 0, 1, 2);
                this._motiv_f = this._validator._integerValue;
                this._motiv_ok = this._validator._attributeOK;
                this._tara_m2 = this._validator.nextAttributeInList(this._params._listaTari, "tara_m2", 2, 4, 2);
                this._tara_m2_ok = this._validator._attributeOK;
                this._cod_m2 = this._validator.nextAttribute("cod_m2", 12, 4, 2);
                this._cod_m2_ok = this._validator._attributeOK;
            }
            if (this._tip.equals("B")) {
                this._motiv = this._validator.nextAttributeInInterval(1L, 3L, "motiv", 0, 1, 1);
                this._motiv_f = this._validator._integerValue;
                this._motiv_ok = this._validator._attributeOK;
                this._tara_m2 = this._validator.nextAttributeInList(this._params._listaTari, "tara_m2", 2, 4, 0);
                this._tara_m2_ok = this._validator._attributeOK;
                this._cod_m2 = this._validator.nextAttribute("cod_m2", 12, 4, 0);
                this._cod_m2_ok = this._validator._attributeOK;
                if (this._motiv_f == 1L && (this._tara_m2 != null || this._cod_m2 != null)) {
                    this._validator.addError(1, "Rmotiv.1", "", this._validator.fillParams("Daca motiv = 1 atunci tara_m2, cod_m2 = null", new Object[0]));
                }
            }
        }
        this.endValidation(n);
    }

    public void aggregation(int n) {
        String string;
        Declaratie390 declaratie390 = (Declaratie390)this._parent;
        String string2 = null;
        boolean bl = false;
        if (this._tip != null && this._cod_m1 != null && this._tara_m1 != null) {
            if (this._tip.equals("A")) {
                string2 = this._cod_m1 + this._tara_m1;
                if (declaratie390._tipDenCodUnic.contains(string2)) {
                    this._validator.addError(1, "R24.4", "(cod_m1 + tara_m1 + den_m1) are aparitii multiple", this._validator.fillParams("operatorul din tara '@0@', avand cod_m1 = '@1@' nu poate avea decat o singura o singura aparitie in cap A ", new Object[]{this._tara_m1, this._cod_m1}));
                } else {
                    declaratie390._tipDenCodUnic.add(string2);
                }
            }
            string = this._cod_m1;
            if (this._cod_m1.toUpperCase().startsWith(this._tara_m1)) {
                string = this._cod_m1.substring(2);
            }
            if (!VATValidation.check(string, this._tara_m1)) {
                this._validator.addError(1, "Rcod_m1", "cod_m1 invalid (nu respecta algoritmul de tara)", this._validator.fillParams("operatorul cod_m1 = '@1@' trebuie sa respecte algoritmul specific '@0@'", new Object[]{this._tara_m1, string}));
            }
        }
        if (this._cod_m2 != null && this._tara_m2 != null) {
            string = this._cod_m2;
            if (this._cod_m2.toUpperCase().startsWith(this._tara_m2)) {
                string = this._cod_m2.substring(2);
            }
            if (!VATValidation.check(string, this._tara_m2)) {
                this._validator.addError(1, "Rcod_m2", "cod_m2 invalid (nu respecta algoritmul de tara)", this._validator.fillParams("operatorul cod_m2 = '@1@' trebuie sa respecte algoritmul specific '@0@'", new Object[]{this._tara_m2, string}));
            }
        }
    }

    public void initialization() {
        this._tip = null;
        this._tip_ok = false;
        this._tara_m1 = null;
        this._tara_m1_ok = false;
        this._den_m1 = null;
        this._motiv = null;
        this._motiv_f = 0L;
        this._motiv_ok = false;
        this._tara_m2 = null;
        this._tara_m2_ok = false;
        this._den_m2 = null;
        this._cod_m1 = null;
        this._cod_m1_ok = false;
        this._cod_m2 = null;
        this._cod_m2_ok = false;
    }
}

